/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.defragmentation;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.MetaPageInfo;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineRecommender;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.IORowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.LeafIO;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;

public class DefragIndexFactory
extends InlineIndexFactory {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final IgniteCacheOffheapManager offheap;
    private final InlineIndex oldIdx;
    private final PageMemory newCachePageMemory;
    private final InlineIndexRowHandlerFactory rowHndFactory = (def, settings) -> oldIdx.segment(0).rowHandler();

    public DefragIndexFactory(IgniteCacheOffheapManager offheap, PageMemory newCachePageMemory, InlineIndex oldIdx) {
        this.offheap = offheap;
        this.oldIdx = oldIdx;
        this.newCachePageMemory = newCachePageMemory;
    }

    @Override
    protected InlineIndexTree createIndexSegment(GridCacheContext<?, ?> cctx, SortedIndexDefinition def, RootPage rootPage, IoStatisticsHolder stats, InlineRecommender recommender, int segmentNum) throws Exception {
        InlineIndexTree tree = new InlineIndexTree(def, cctx.group(), def.treeName(), this.offheap, this.offheap.reuseListForIndex(def.treeName()), this.newCachePageMemory, this.pageIoResolver(), rootPage.pageId().pageId(), rootPage.isAllocated(), this.oldIdx.inlineSize(), cctx.config().getSqlIndexMaxInlineSize(), def.keyTypeSettings(), null, stats, this.rowHndFactory, null);
        MetaPageInfo oldInfo = this.oldIdx.segment(segmentNum).metaInfo();
        BPlusInnerIO innerIO = (BPlusInnerIO)DefragIndexFactory.wrap(tree.latestInnerIO(), tree.rowHandler());
        BPlusLeafIO leafIo = (BPlusLeafIO)DefragIndexFactory.wrap(tree.latestLeafIO(), tree.rowHandler());
        tree.setIos(new IOVersions((PageIO[])new BPlusInnerIO[]{innerIO}), new IOVersions((PageIO[])new BPlusLeafIO[]{leafIo}));
        tree.copyMetaInfo(oldInfo);
        tree.enableSequentialWriteMode();
        return tree;
    }

    @Override
    protected RootPage rootPage(GridCacheContext<?, ?> ctx, String treeName, int segment) throws Exception {
        return this.offheap.rootPageForIndex(ctx.cacheId(), treeName, segment);
    }

    private PageIoResolver pageIoResolver() {
        return pageAddr -> {
            PageIO io = PageIoResolver.DEFAULT_PAGE_IO_RESOLVER.resolve(pageAddr);
            if (io instanceof BPlusMetaIO) {
                return io;
            }
            return DefragIndexFactory.wrap((BPlusIO)io, this.rowHndFactory.create(null, null));
        };
    }

    static BPlusIO<IndexRow> wrap(BPlusIO<IndexRow> io, InlineIndexRowHandler rowHnd) {
        assert (io instanceof InlineIO);
        if (io instanceof BPlusInnerIO) {
            assert (io instanceof AbstractInlineInnerIO || io instanceof InnerIO);
            return new BPlusInnerIoDelegate<BPlusInnerIO>((BPlusInnerIO)io, rowHnd);
        }
        assert (io instanceof AbstractInlineLeafIO || io instanceof LeafIO);
        return new BPlusLeafIoDelegate<BPlusLeafIO>((BPlusLeafIO)io, rowHnd);
    }

    private static <IO extends BPlusIO<?>> void storeByOffset(IO io, long pageAddr, int off, DefragIndexRowImpl row) {
        int payloadSize = ((InlineIO)((Object)io)).inlineSize();
        assert (row.link() != 0L);
        PageUtils.putBytes(pageAddr, off, row.values);
        IORowHandler.store(pageAddr, off + payloadSize, row);
    }

    private static <T extends BPlusIO<IndexRow>> IndexRow lookupRow(InlineIndexRowHandler rowHnd, long pageAddr, int idx, T io) {
        long link = ((InlineIO)((Object)io)).link(pageAddr, idx);
        int off = io.offset(idx);
        int inlineSize = ((InlineIO)((Object)io)).inlineSize();
        byte[] values = rowHnd.inlineIndexKeyTypes().isEmpty() ? EMPTY_BYTES : PageUtils.getBytes(pageAddr, off, inlineSize);
        return new DefragIndexRowImpl(rowHnd, (CacheDataRow)new CacheDataRowAdapter(link), values);
    }

    public static class DefragIndexRowImpl
    extends IndexRowImpl {
        private final byte[] values;

        public DefragIndexRowImpl(InlineIndexRowHandler rowHnd, CacheDataRow row, byte[] values) {
            super(rowHnd, row);
            this.values = values;
        }

        public static DefragIndexRowImpl create(InlineIndexRowHandler rowHnd, long newLink, DefragIndexRowImpl oldValue) {
            return new DefragIndexRowImpl(rowHnd, (CacheDataRow)new CacheDataRowAdapter(newLink), oldValue.values);
        }
    }

    private static class BPlusLeafIoDelegate<IO extends BPlusLeafIO<IndexRow>>
    extends BPlusLeafIO<IndexRow>
    implements InlineIO {
        private final IO io;
        private final InlineIndexRowHandler rowHnd;

        private BPlusLeafIoDelegate(IO io, InlineIndexRowHandler rowHnd) {
            super(((PageIO)io).getType(), ((PageIO)io).getVersion(), ((BPlusIO)io).getItemSize());
            this.io = io;
            this.rowHnd = rowHnd;
        }

        @Override
        public void storeByOffset(long pageAddr, int off, IndexRow row) throws IgniteCheckedException {
            this.assertPageType(pageAddr);
            DefragIndexFactory.storeByOffset(this.io, pageAddr, off, (DefragIndexRowImpl)row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<IndexRow> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            ((BPlusIO)this.io).store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
        }

        @Override
        public IndexRow getLookupRow(BPlusTree<IndexRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return DefragIndexFactory.lookupRow(this.rowHnd, pageAddr, idx, this);
        }

        @Override
        public long link(long pageAddr, int idx) {
            return ((InlineIO)this.io).link(pageAddr, idx);
        }

        @Override
        public int inlineSize() {
            return ((InlineIO)this.io).inlineSize();
        }
    }

    private static class BPlusInnerIoDelegate<IO extends BPlusInnerIO<IndexRow>>
    extends BPlusInnerIO<IndexRow>
    implements InlineIO {
        private final IO io;
        private final InlineIndexRowHandler rowHnd;

        private BPlusInnerIoDelegate(IO io, InlineIndexRowHandler rowHnd) {
            super(((PageIO)io).getType(), ((PageIO)io).getVersion(), ((BPlusIO)io).canGetRow(), ((BPlusIO)io).getItemSize());
            this.io = io;
            this.rowHnd = rowHnd;
        }

        @Override
        public void storeByOffset(long pageAddr, int off, IndexRow row) throws IgniteCheckedException {
            this.assertPageType(pageAddr);
            DefragIndexFactory.storeByOffset(this.io, pageAddr, off, (DefragIndexRowImpl)row);
        }

        @Override
        public void store(long dstPageAddr, int dstIdx, BPlusIO<IndexRow> srcIo, long srcPageAddr, int srcIdx) throws IgniteCheckedException {
            ((BPlusIO)this.io).store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
        }

        @Override
        public IndexRow getLookupRow(BPlusTree<IndexRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
            return DefragIndexFactory.lookupRow(this.rowHnd, pageAddr, idx, this);
        }

        @Override
        public long link(long pageAddr, int idx) {
            return ((InlineIO)this.io).link(pageAddr, idx);
        }

        @Override
        public int inlineSize() {
            return ((InlineIO)this.io).inlineSize();
        }
    }
}

