/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.message.JobStateResponse;
import org.apache.ignite.internal.compute.message.JobStateResponseBuilder;
import org.apache.ignite.internal.compute.message.JobStateResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobStateResponseImpl
implements JobStateResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private JobState state;
    private byte[] stateByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private JobStateResponseImpl(JobState state, byte[] stateByteArray, Throwable throwable, byte[] throwableByteArray) {
        this.state = state;
        this.stateByteArray = stateByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] stateByteArray() {
        return this.stateByteArray;
    }

    @Override
    public JobState state() {
        return this.state;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return JobStateResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobStateResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobStateResponseImpl otherMessage = (JobStateResponseImpl)other;
        return Objects.equals(this.state, otherMessage.state) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.state, this.throwable);
        return result;
    }

    public JobStateResponseImpl clone() {
        try {
            return (JobStateResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobStateResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject stateByteArraymo = marshaller.marshal((Object)this.state);
        usedDescriptors.addAll((IntCollection)stateByteArraymo.usedDescriptorIds());
        this.stateByteArray = stateByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.state = (JobState)marshaller.unmarshal(this.stateByteArray, descriptorsObj);
        this.stateByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements JobStateResponseBuilder {
        private JobState state;
        private byte[] stateByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public JobStateResponseBuilder state(JobState state) {
            this.state = state;
            return this;
        }

        @Override
        public JobStateResponseBuilder stateByteArray(byte[] stateByteArray) {
            this.stateByteArray = stateByteArray;
            return this;
        }

        @Override
        public JobStateResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public JobStateResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public JobState state() {
            return this.state;
        }

        @Override
        public byte[] stateByteArray() {
            return this.stateByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public JobStateResponse build() {
            return new JobStateResponseImpl(this.state, this.stateByteArray, this.throwable, this.throwableByteArray);
        }
    }
}

