/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableExpandDisjunctionForTableRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class ExpandDisjunctionForTableRule
extends RelRule<Config>
implements TransformationRule {
    protected ExpandDisjunctionForTableRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    private RexNode apply(RexNode condition, RelNode relNode, List<RelDataTypeField> fieldList, RelBuilder relBuilder, RelMetadataQuery mq) {
        HashMap<Integer, RexTableInputRef.RelTableRef> inputRefToTableRef = new HashMap<Integer, RexTableInputRef.RelTableRef>();
        ImmutableBitSet columnBits = RelOptUtil.InputFinder.bits(condition);
        if (columnBits.isEmpty()) {
            return condition;
        }
        for (int columnBit : columnBits.asList()) {
            Set<RexTableInputRef.RelTableRef> relTableRefs;
            Set<RexNode> exprLineage = mq.getExpressionLineage(relNode, RexInputRef.of(columnBit, fieldList));
            if (exprLineage == null || (relTableRefs = RexUtil.gatherTableReferences(Lists.newArrayList(exprLineage))).size() != 1) continue;
            inputRefToTableRef.put(columnBit, relTableRefs.iterator().next());
        }
        ExpandDisjunctionForTableHelper expandHelper = new ExpandDisjunctionForTableHelper(inputRefToTableRef, relBuilder, ((Config)this.config).bloat());
        Map expandResult = expandHelper.expand(condition);
        RexNode newCondition = condition;
        for (RexNode expandCondition : expandResult.values()) {
            newCondition = relBuilder.and(newCondition, expandCondition);
        }
        return newCondition;
    }

    private static void matchFilter(ExpandDisjunctionForTableRule rule, RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelBuilder relBuilder = call.builder();
        RexNode newCondition = rule.apply(filter.getCondition(), filter, filter.getRowType().getFieldList(), relBuilder, mq);
        if (newCondition.equals(filter.getCondition())) {
            return;
        }
        Filter newFilter = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
        call.transformTo(newFilter);
    }

    private static void matchJoin(ExpandDisjunctionForTableRule rule, RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelBuilder relBuilder = call.builder();
        ArrayList fieldList = Lists.newArrayList(join.getLeft().getRowType().getFieldList());
        fieldList.addAll(join.getRight().getRowType().getFieldList());
        RexNode newCondition = rule.apply(join.getCondition(), join, fieldList, relBuilder, mq);
        if (newCondition.equals(join.getCondition())) {
            return;
        }
        Join newJoin = join.copy(join.getTraitSet(), newCondition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoin);
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config FILTER = ImmutableExpandDisjunctionForTableRule.Config.builder().withMatchHandler((x$0, x$1) -> ExpandDisjunctionForTableRule.access$200(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Filter.class).anyInputs());
        public static final Config JOIN = ImmutableExpandDisjunctionForTableRule.Config.builder().withMatchHandler((x$0, x$1) -> ExpandDisjunctionForTableRule.access$100(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Join.class).anyInputs());

        @Override
        default public ExpandDisjunctionForTableRule toRule() {
            return new ExpandDisjunctionForTableRule(this);
        }

        default public int bloat() {
            return 100;
        }

        public RelRule.MatchHandler<ExpandDisjunctionForTableRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<ExpandDisjunctionForTableRule> var1);
    }

    private static class ExpandDisjunctionForTableHelper
    extends RexUtil.ExpandDisjunctionHelper<RexTableInputRef.RelTableRef> {
        private final Map<Integer, RexTableInputRef.RelTableRef> inputRefToTableRef;

        private ExpandDisjunctionForTableHelper(Map<Integer, RexTableInputRef.RelTableRef> inputRefToTableRef, RelBuilder relBuilder, int maxNodeCount) {
            super(relBuilder, maxNodeCount);
            this.inputRefToTableRef = inputRefToTableRef;
        }

        @Override
        protected boolean canReturnEarly(RexNode condition, Map<RexTableInputRef.RelTableRef, RexNode> additionalConditions) {
            ImmutableBitSet inputRefs = RelOptUtil.InputFinder.bits(condition);
            if (inputRefs.isEmpty()) {
                return true;
            }
            RexTableInputRef.RelTableRef tableRef = this.inputRefsBelongToOneTable(inputRefs);
            if (tableRef != null) {
                this.checkExpandCount(condition.nodeCount());
                additionalConditions.put(tableRef, condition);
                return true;
            }
            return false;
        }

        private  @Nullable RexTableInputRef.RelTableRef inputRefsBelongToOneTable(ImmutableBitSet inputRefs) {
            RexTableInputRef.RelTableRef tableRef = this.inputRefToTableRef.get(inputRefs.nth(0));
            if (tableRef == null) {
                return null;
            }
            for (int inputBit : inputRefs.asList()) {
                RexTableInputRef.RelTableRef inputBitTableRef = this.inputRefToTableRef.get(inputBit);
                if (tableRef.equals(inputBitTableRef)) continue;
                return null;
            }
            return tableRef;
        }
    }
}

