/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.queue;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

class QueueEntry<R>
implements Runnable,
Comparable<QueueEntry<R>> {
    private static final AtomicLong seq = new AtomicLong(Long.MIN_VALUE);
    private final CompletableFuture<R> future = new CompletableFuture();
    private final Callable<CompletableFuture<R>> jobAction;
    private final int priority;
    private final long seqNum;
    @Nullable
    private Thread workerThread;
    @Nullable
    private CompletableFuture<R> jobFuture;
    private final Lock lock = new ReentrantLock();
    private volatile boolean isInterrupted;

    QueueEntry(Callable<CompletableFuture<R>> jobAction, int priority) {
        this.jobAction = jobAction;
        this.priority = priority;
        this.seqNum = seq.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            this.workerThread = Thread.currentThread();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.jobFuture = this.jobAction.call();
            if (this.jobFuture == null) {
                this.future.complete(null);
            } else {
                this.jobFuture.whenComplete(CompletableFutures.copyStateTo(this.future));
            }
        }
        catch (Throwable e) {
            this.future.completeExceptionally(e);
        }
        finally {
            this.lock.lock();
            try {
                this.workerThread = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    CompletableFuture<R> toFuture() {
        return this.future;
    }

    void interrupt() {
        this.lock.lock();
        try {
            if (this.workerThread != null) {
                this.isInterrupted = true;
                this.workerThread.interrupt();
            }
            if (this.jobFuture != null) {
                this.isInterrupted = true;
                this.jobFuture.cancel(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isInterrupted() {
        return this.isInterrupted;
    }

    @Override
    public int compareTo(QueueEntry o) {
        int compare = Integer.compare(o.priority, this.priority);
        if (compare == 0 && this != o) {
            return this.seqNum < o.seqNum ? -1 : 1;
        }
        return compare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueEntry that = (QueueEntry)o;
        return this.seqNum == that.seqNum;
    }

    public int hashCode() {
        return Long.hashCode(this.seqNum);
    }
}

