/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum SqlLibrary {
    STANDARD("", "standard"),
    SPATIAL("s", "spatial"),
    ALL("*", "all"),
    BIG_QUERY("b", "bigquery"),
    CALCITE("c", "calcite"),
    HIVE("h", "hive"),
    MSSQL("q", "mssql"),
    MYSQL("m", "mysql"),
    ORACLE("o", "oracle"),
    POSTGRESQL("p", "postgresql"),
    SNOWFLAKE("f", "snowflake"),
    SPARK("s", "spark");

    public static final Map<String, SqlLibrary> MAP;
    public final String abbrev;
    public final String fun;

    private SqlLibrary(String abbrev, String fun) {
        this.abbrev = Objects.requireNonNull(abbrev, "abbrev");
        this.fun = Objects.requireNonNull(fun, "fun");
        Preconditions.checkArgument((boolean)fun.equals(this.name().toLowerCase(Locale.ROOT).replace("_", "")));
    }

    public List<SqlLibrary> children() {
        switch (this) {
            case ALL: {
                return ImmutableList.of((Object)((Object)BIG_QUERY), (Object)((Object)CALCITE), (Object)((Object)HIVE), (Object)((Object)MSSQL), (Object)((Object)MYSQL), (Object)((Object)ORACLE), (Object)((Object)POSTGRESQL), (Object)((Object)SNOWFLAKE), (Object)((Object)SPARK));
            }
        }
        return ImmutableList.of();
    }

    public static @Nullable SqlLibrary of(String name) {
        return MAP.get(name);
    }

    public static List<SqlLibrary> parse(String libraryNameList) {
        ImmutableList.Builder list = ImmutableList.builder();
        if (!libraryNameList.isEmpty()) {
            for (String libraryName : libraryNameList.split(",")) {
                @Nullable SqlLibrary library = SqlLibrary.of(libraryName);
                if (library == null) {
                    throw new IllegalArgumentException("unknown library '" + libraryName + "'");
                }
                list.add((Object)library);
            }
        }
        return list.build();
    }

    public static List<SqlLibrary> expand(Iterable<? extends SqlLibrary> libraries) {
        LinkedHashSet set = new LinkedHashSet();
        libraries.forEach(library -> SqlLibrary.addExpansion(set, library));
        return ImmutableList.copyOf(set);
    }

    private static void addExpansion(Set<SqlLibrary> set, SqlLibrary library) {
        if (set.add(library)) {
            library.children().forEach(subLibrary -> SqlLibrary.addExpansion(set, subLibrary));
        }
    }

    public static List<SqlLibrary> expandUp(Iterable<? extends SqlLibrary> libraries) {
        LinkedHashSet set = new LinkedHashSet();
        libraries.forEach(library -> SqlLibrary.addParent(set, library));
        return ImmutableList.copyOf(set);
    }

    private static void addParent(Set<SqlLibrary> set, SqlLibrary library) {
        if (ALL.children().contains((Object)library)) {
            set.add(ALL);
        }
        set.add(library);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SqlLibrary value : SqlLibrary.values()) {
            builder.put((Object)value.name(), (Object)value);
            builder.put((Object)value.fun, (Object)value);
        }
        MAP = builder.build();
    }
}

