/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequesterBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncFullDuplexClientExample {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(5, TimeUnit.SECONDS).build();
        HttpAsyncRequester requester = AsyncRequesterBootstrap.bootstrap().setIOReactorConfig(ioReactorConfig).setHttpProcessor(HttpProcessors.customClient(null).addLast((request, entity, context) -> request.removeHeaders("Expect")).build()).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println(connection.getRemoteAddress() + " " + new RequestLine(request));
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println(connection.getRemoteAddress() + " " + new StatusLine(response));
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection kept alive)");
                } else {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection closed)");
                }
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("HTTP requester shutting down");
            requester.close(CloseMode.GRACEFUL);
        }));
        requester.start();
        final URI requestUri = new URI("http://httpbin.org/post");
        final AsyncRequestProducer requestProducer = AsyncRequestBuilder.post((URI)requestUri).setEntity("stuff").build();
        final BasicResponseConsumer responseConsumer = new BasicResponseConsumer((AsyncEntityConsumer)new StringAsyncEntityConsumer());
        final CountDownLatch latch = new CountDownLatch(1);
        requester.execute(new AsyncClientExchangeHandler(){

            public void releaseResources() {
                requestProducer.releaseResources();
                responseConsumer.releaseResources();
                latch.countDown();
            }

            public void cancel() {
                System.out.println(requestUri + " cancelled");
            }

            public void failed(Exception cause) {
                System.out.println(requestUri + "->" + cause);
            }

            public void produceRequest(RequestChannel channel, HttpContext httpContext) throws HttpException, IOException {
                requestProducer.sendRequest(channel, httpContext);
            }

            public int available() {
                return requestProducer.available();
            }

            public void produce(DataStreamChannel channel) throws IOException {
                requestProducer.produce(channel);
            }

            public void consumeInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                System.out.println(requestUri + "->" + response.getCode());
            }

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                System.out.println(requestUri + "->" + response.getCode());
                responseConsumer.consumeResponse(response, entityDetails, httpContext, null);
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                responseConsumer.updateCapacity(capacityChannel);
            }

            public void consume(ByteBuffer src) throws IOException {
                responseConsumer.consume(src);
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                responseConsumer.streamEnd(trailers);
            }
        }, Timeout.ofSeconds((long)30L), (HttpContext)HttpCoreContext.create());
        latch.await(1L, TimeUnit.MINUTES);
        System.out.println("Shutting down I/O reactor");
        requester.initiateShutdown();
    }
}

