/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.datastore.gorm.neo4j.connections;

import org.grails.datastore.mapping.core.connections.DefaultConnectionSource;
import org.neo4j.driver.Driver;
import org.neo4j.harness.ServerControls;

import java.io.IOException;

/**
 * A {@link org.grails.datastore.mapping.core.connections.ConnectionSource} for embedded Neo4j
 *
 * @author Graeme Rocher
 * @since 6.0
 */
public class Neo4jEmbeddedConnectionSource extends DefaultConnectionSource<Driver, Neo4jConnectionSourceSettings> {
    protected final ServerControls serverControls;

    Neo4jEmbeddedConnectionSource(String name, Driver source, Neo4jConnectionSourceSettings settings, ServerControls serverControls) {
        super(name, source, settings);
        this.serverControls = serverControls;
    }

    public ServerControls getServerControls() {
        return serverControls;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        } finally {
            serverControls.close();
        }
    }
}
