/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.request;

import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationWrapper;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PreDestroyViewMapEvent;
import jakarta.faces.event.SystemEvent;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.impl.security.SecurityAwareViewHandler;

public class DeltaSpikeApplicationWrapper
extends ApplicationWrapper {
    private final Application wrapped;
    private final boolean preDestroyViewMapEventFilterMode;
    private final ProjectStage projectStage;

    public DeltaSpikeApplicationWrapper(Application wrapped, JsfModuleConfig jsfModuleConfig, boolean preDestroyViewMapEventFilterMode, ProjectStage projectStage) {
        this.wrapped = wrapped;
        this.preDestroyViewMapEventFilterMode = preDestroyViewMapEventFilterMode;
        this.projectStage = projectStage;
    }

    public ProjectStage getProjectStage() {
        if (this.projectStage == null) {
            return this.getWrapped().getProjectStage();
        }
        return this.projectStage;
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        if (!PreDestroyViewMapEvent.class.isAssignableFrom(systemEventClass) || this.isPreDestroyViewMapEventAllowed(facesContext)) {
            super.publishEvent(facesContext, systemEventClass, source);
        }
    }

    private boolean isPreDestroyViewMapEventAllowed(FacesContext facesContext) {
        return !this.preDestroyViewMapEventFilterMode || !Boolean.TRUE.equals(facesContext.getExternalContext().getRequestMap().get(SecurityAwareViewHandler.PRE_DESTROY_VIEW_MAP_EVENT_FILTER_ENABLED));
    }

    public Application getWrapped() {
        return this.wrapped;
    }
}

