/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.criteria.predicate;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import org.apache.deltaspike.data.api.criteria.Criteria;
import org.apache.deltaspike.data.impl.criteria.predicate.PredicateBuilder;

public class JoinBuilder<P, R, E>
implements PredicateBuilder<P> {
    private final Criteria<R, R> criteria;
    private final JoinType joinType;
    private SingularAttribute<? super P, R> singular;
    private ListAttribute<? super P, R> list;
    private CollectionAttribute<? super P, R> collection;
    private SetAttribute<? super P, R> set;
    private MapAttribute<? super P, E, R> map;

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType) {
        this.criteria = criteria;
        this.joinType = joinType;
    }

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType, SingularAttribute<? super P, R> singular) {
        this(criteria, joinType);
        this.singular = singular;
    }

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType, ListAttribute<? super P, R> list) {
        this(criteria, joinType);
        this.list = list;
    }

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType, CollectionAttribute<? super P, R> collection) {
        this(criteria, joinType);
        this.collection = collection;
    }

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType, SetAttribute<? super P, R> set) {
        this(criteria, joinType);
        this.set = set;
    }

    public JoinBuilder(Criteria<R, R> criteria, JoinType joinType, MapAttribute<? super P, E, R> map) {
        this(criteria, joinType);
        this.map = map;
    }

    @Override
    public List<Predicate> build(CriteriaBuilder builder, Path<P> path) {
        Join join = null;
        join = this.singular != null ? this.joinSingular((From)path) : (this.list != null ? this.joinList((From)path) : (this.collection != null ? this.joinCollection((From)path) : (this.set != null ? this.joinSet((From)path) : this.joinMap((From)path))));
        return this.criteria.predicates(builder, (Path)join);
    }

    private Join joinSingular(From path) {
        if (this.joinType == null) {
            return path.join(this.singular);
        }
        return path.join(this.singular, this.joinType);
    }

    private Join joinList(From path) {
        if (this.joinType == null) {
            return path.join(this.list);
        }
        return path.join(this.list, this.joinType);
    }

    private Join joinCollection(From path) {
        if (this.joinType == null) {
            return path.join(this.collection);
        }
        return path.join(this.collection, this.joinType);
    }

    private Join joinSet(From path) {
        if (this.joinType == null) {
            return path.join(this.set);
        }
        return path.join(this.set, this.joinType);
    }

    private Join joinMap(From path) {
        if (this.joinType == null) {
            return path.join(this.map);
        }
        return path.join(this.map, this.joinType);
    }
}

