/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.mozilla.javascript.AbstractEcmaObjectOperations;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.CompoundOperationMap;
import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SerializableCallable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.Undefined;

class NativeProxy
extends ScriptableObject {
    private static final long serialVersionUID = 6676871870513494844L;
    private static final String PROXY_TAG = "Proxy";
    private static final String TRAP_GET_PROTOTYPE_OF = "getPrototypeOf";
    private static final String TRAP_SET_PROTOTYPE_OF = "setPrototypeOf";
    private static final String TRAP_IS_EXTENSIBLE = "isExtensible";
    private static final String TRAP_PREVENT_EXTENSIONS = "preventExtensions";
    private static final String TRAP_GET_OWN_PROPERTY_DESCRIPTOR = "getOwnPropertyDescriptor";
    private static final String TRAP_DEFINE_PROPERTY = "defineProperty";
    private static final String TRAP_HAS = "has";
    private static final String TRAP_GET = "get";
    private static final String TRAP_SET = "set";
    private static final String TRAP_DELETE_PROPERTY = "deleteProperty";
    private static final String TRAP_OWN_KEYS = "ownKeys";
    private static final String TRAP_APPLY = "apply";
    private static final String TRAP_CONSTRUCT = "construct";
    private ScriptableObject targetObj;
    private Scriptable handlerObj;
    private final String typeOf;

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, PROXY_TAG, 2, null, null, NativeProxy::constructor){

            @Override
            public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
                NativeProxy obj = (NativeProxy)this.getTargetConstructor().construct(cx, scope, args);
                obj.setPrototypeDirect(this.getClassPrototype());
                obj.setParentScope(scope);
                return obj;
            }
        };
        constructor.defineConstructorMethod(scope, "revocable", 2, NativeProxy::revocable);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    private NativeProxy(ScriptableObject target, Scriptable handler) {
        this.targetObj = target;
        this.handlerObj = handler;
        this.typeOf = target == null || !(target instanceof Callable) ? super.getTypeOf() : target.getTypeOf();
    }

    @Override
    public String getClassName() {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        return target.getClassName();
    }

    @Override
    public boolean has(String name, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_HAS);
        if (trap != null) {
            ScriptableObject.DescriptorInfo targetDesc;
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, name}));
            if (!(booleanTrapResult || (targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), name)) == null || !targetDesc.isConfigurable(false) && target.isExtensible())) {
                throw ScriptRuntime.typeError("proxy can't report an existing own property '" + name + "' as non-existent on a non-extensible object");
            }
            return booleanTrapResult;
        }
        if (start == this) {
            start = target;
        }
        return target.has(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_HAS);
        if (trap != null) {
            ScriptableObject.DescriptorInfo targetDesc;
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, ScriptRuntime.toString(index)}));
            if (!(booleanTrapResult || (targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), index)) == null || !targetDesc.isConfigurable(false) && target.isExtensible())) {
                throw ScriptRuntime.typeError("proxy can't check an existing property ' + name + ' existance on an not configurable or not extensible object");
            }
            return booleanTrapResult;
        }
        if (start == this) {
            start = target;
        }
        return target.has(index, start);
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_HAS);
        if (trap != null) {
            ScriptableObject.DescriptorInfo targetDesc;
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, key}));
            if (!(booleanTrapResult || (targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), key)) == null || !targetDesc.isConfigurable(false) && target.isExtensible())) {
                throw ScriptRuntime.typeError("proxy can't check an existing property ' + name + ' existance on an not configurable or not extensible object");
            }
            return booleanTrapResult;
        }
        if (start == this) {
            start = target;
        }
        SymbolScriptable symbolScriptableTarget = NativeProxy.ensureSymbolScriptable(target);
        return symbolScriptableTarget.has(key, start);
    }

    @Override
    Object[] getIds(CompoundOperationMap map, boolean getNonEnumerable, boolean getSymbols) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_OWN_KEYS);
        if (trap != null) {
            Object[] targetKeys;
            Object res = this.callTrap(trap, new Object[]{target});
            if (!(res instanceof Scriptable)) {
                throw ScriptRuntime.typeError("ownKeys trap must be an object");
            }
            if (!ScriptRuntime.isArrayLike((Scriptable)res)) {
                throw ScriptRuntime.typeError("ownKeys trap must be an array like object");
            }
            Context cx = Context.getContext();
            List<Object> trapResult = AbstractEcmaObjectOperations.createListFromArrayLike(cx, (Scriptable)res, o -> o instanceof CharSequence || o instanceof NativeString || ScriptRuntime.isSymbol(o), "proxy [[OwnPropertyKeys]] must return an array with only string and symbol elements");
            boolean extensibleTarget = target.isExtensible();
            try (CompoundOperationMap targetMap = target.startCompoundOp(false);){
                targetKeys = target.getIds(targetMap, true, true);
            }
            HashSet<Object> uncheckedResultKeys = new HashSet<Object>(trapResult);
            if (uncheckedResultKeys.size() != trapResult.size()) {
                throw ScriptRuntime.typeError("ownKeys trap result must not contain duplicates");
            }
            ArrayList<Object> targetConfigurableKeys = new ArrayList<Object>();
            ArrayList<Object> targetNonconfigurableKeys = new ArrayList<Object>();
            for (Object targetKey : targetKeys) {
                ScriptableObject.DescriptorInfo desc = target.getOwnPropertyDescriptor(cx, targetKey);
                if (desc != null && desc.isConfigurable(false)) {
                    targetNonconfigurableKeys.add(targetKey);
                    continue;
                }
                targetConfigurableKeys.add(targetKey);
            }
            if (extensibleTarget && targetNonconfigurableKeys.size() == 0) {
                return trapResult.toArray();
            }
            for (Object e : targetNonconfigurableKeys) {
                if (!uncheckedResultKeys.contains(e)) {
                    throw ScriptRuntime.typeError("proxy can't skip a non-configurable property '" + String.valueOf(e) + "'");
                }
                uncheckedResultKeys.remove(e);
            }
            if (extensibleTarget) {
                return trapResult.toArray();
            }
            for (Object e : targetConfigurableKeys) {
                if (!uncheckedResultKeys.contains(e)) {
                    throw ScriptRuntime.typeError("proxy can't skip a configurable property " + String.valueOf(e));
                }
                uncheckedResultKeys.remove(e);
            }
            if (uncheckedResultKeys.size() > 0) {
                throw ScriptRuntime.typeError("proxy can't skip properties");
            }
        }
        try (CompoundOperationMap targetMap = target.startCompoundOp(false);){
            Object[] objectArray = target.getIds(targetMap, getNonEnumerable, getSymbols);
            return objectArray;
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_GET);
        if (trap != null) {
            Object trapResult = this.callTrap(trap, new Object[]{target, name, this});
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), name);
            if (targetDesc != null && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(trapResult, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.getter) && !Undefined.isUndefined(trapResult)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
            }
            return trapResult;
        }
        if (start == this) {
            start = target;
        }
        return target.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_GET);
        if (trap != null) {
            Object trapResult = this.callTrap(trap, new Object[]{target, ScriptRuntime.toString(index), this});
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), index);
            if (targetDesc != null && !Undefined.isUndefined(targetDesc) && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(trapResult, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.getter) && !Undefined.isUndefined(trapResult)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
            }
            return trapResult;
        }
        if (start == this) {
            start = target;
        }
        return target.get(index, start);
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_GET);
        if (trap != null) {
            Object trapResult = this.callTrap(trap, new Object[]{target, key, this});
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), key);
            if (targetDesc != null && !Undefined.isUndefined(targetDesc) && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(trapResult, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.getter) && !Undefined.isUndefined(trapResult)) {
                    throw ScriptRuntime.typeError("proxy get has to return the same value as the plain call");
                }
            }
            return trapResult;
        }
        if (start == this) {
            start = target;
        }
        SymbolScriptable symbolScriptableTarget = NativeProxy.ensureSymbolScriptable(target);
        return symbolScriptableTarget.get(key, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_SET);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, name, value}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), name);
            if (targetDesc != null && !Undefined.isUndefined(targetDesc) && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(value, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy set has to use the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.setter)) {
                    throw ScriptRuntime.typeError("proxy set has to be available");
                }
            }
            return;
        }
        if (start == this) {
            start = target;
        }
        target.put(name, start, value);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_SET);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, ScriptRuntime.toString(index), value}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), index);
            if (targetDesc != null && !Undefined.isUndefined(targetDesc) && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(value, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy set has to use the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.setter)) {
                    throw ScriptRuntime.typeError("proxy set has to be available");
                }
            }
            return;
        }
        if (start == this) {
            start = target;
        }
        target.put(index, start, value);
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_SET);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, key, value}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), key);
            if (targetDesc != null && !Undefined.isUndefined(targetDesc) && targetDesc.isConfigurable(false)) {
                if (targetDesc.isDataDescriptor() && targetDesc.isWritable(false) && !Objects.equals(value, targetDesc.value)) {
                    throw ScriptRuntime.typeError("proxy set has to use the same value as the plain call");
                }
                if (targetDesc.isAccessorDescriptor() && Undefined.isUndefined(targetDesc.setter)) {
                    throw ScriptRuntime.typeError("proxy set has to be available");
                }
            }
            return;
        }
        if (start == this) {
            start = target;
        }
        SymbolScriptable symbolScriptableTarget = NativeProxy.ensureSymbolScriptable(target);
        symbolScriptableTarget.put(key, start, value);
    }

    @Override
    public void delete(String name) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_DELETE_PROPERTY);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, name}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), name);
            if (targetDesc == null) {
                return;
            }
            if (targetDesc.isConfigurable(false) || !target.isExtensible()) {
                throw ScriptRuntime.typeError("proxy can't delete an existing own property ' + name + ' on an not configurable or not extensible object");
            }
            return;
        }
        target.delete(name);
    }

    @Override
    public void delete(int index) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_DELETE_PROPERTY);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, ScriptRuntime.toString(index)}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), index);
            if (targetDesc == null) {
                return;
            }
            if (targetDesc.isConfigurable(false) || !target.isExtensible()) {
                throw ScriptRuntime.typeError("proxy can't delete an existing own property ' + name + ' on an not configurable or not extensible object");
            }
            return;
        }
        target.delete(index);
    }

    @Override
    public void delete(Symbol key) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_DELETE_PROPERTY);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, key}));
            if (!booleanTrapResult) {
                return;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), key);
            if (targetDesc == null) {
                return;
            }
            if (targetDesc.isConfigurable(false) || !target.isExtensible()) {
                throw ScriptRuntime.typeError("proxy can't delete an existing own property ' + name + ' on an not configurable or not extensible object");
            }
            return;
        }
        SymbolScriptable symbolScriptableTarget = NativeProxy.ensureSymbolScriptable(target);
        symbolScriptableTarget.delete(key);
    }

    @Override
    protected ScriptableObject.DescriptorInfo getOwnPropertyDescriptor(Context cx, Object id) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_GET_OWN_PROPERTY_DESCRIPTOR);
        if (trap != null) {
            ScriptableObject.DescriptorInfo targetDesc;
            Object trapResultObj = this.callTrap(trap, new Object[]{target, id});
            if (!(Undefined.isUndefined(trapResultObj) || trapResultObj instanceof Scriptable && !ScriptRuntime.isSymbol(trapResultObj))) {
                throw ScriptRuntime.typeError("getOwnPropertyDescriptor trap has to return undefined or an object");
            }
            ScriptableObject.DescriptorInfo descriptorInfo = targetDesc = ScriptRuntime.isSymbol(id) ? target.getOwnPropertyDescriptor(cx, id) : target.getOwnPropertyDescriptor(cx, ScriptRuntime.toString(id));
            if (Undefined.isUndefined(trapResultObj)) {
                if (Undefined.isUndefined(targetDesc)) {
                    return null;
                }
                if (targetDesc.isConfigurable(false) || !target.isExtensible()) {
                    throw ScriptRuntime.typeError("proxy can't report an existing own property '" + String.valueOf(id) + "' as non-existent on a non-extensible object");
                }
                return null;
            }
            Scriptable trapResult = (Scriptable)trapResultObj;
            if (trapResultObj != null) {
                Object value = ScriptableObject.getProperty(trapResult, "value");
                int attributes = NativeProxy.applyDescriptorToAttributeBitset(7, NativeProxy.getProperty(trapResult, "enumerable"), NativeProxy.getProperty(trapResult, "writable"), NativeProxy.getProperty(trapResult, "configurable"));
                ScriptableObject.DescriptorInfo desc = ScriptableObject.buildDataDescriptor(value, attributes);
                return desc;
            }
            return null;
        }
        if (ScriptRuntime.isSymbol(id)) {
            return target.getOwnPropertyDescriptor(cx, id);
        }
        return target.getOwnPropertyDescriptor(cx, ScriptRuntime.toString(id));
    }

    @Override
    public boolean defineOwnProperty(Context cx, Object id, ScriptableObject.DescriptorInfo desc) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_DEFINE_PROPERTY);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, id, desc.toObject(trap.getDeclarationScope())}));
            if (!booleanTrapResult) {
                return false;
            }
            ScriptableObject.DescriptorInfo targetDesc = target.getOwnPropertyDescriptor(Context.getContext(), id);
            boolean extensibleTarget = target.isExtensible();
            boolean settingConfigFalse = desc.isConfigurable(false);
            if (targetDesc == null) {
                if (!extensibleTarget || settingConfigFalse) {
                    throw ScriptRuntime.typeError("proxy can't define an incompatible property descriptor");
                }
            } else {
                if (!AbstractEcmaObjectOperations.isCompatiblePropertyDescriptor(cx, extensibleTarget, desc, targetDesc)) {
                    throw ScriptRuntime.typeError("proxy can't define an incompatible property descriptor");
                }
                if (settingConfigFalse && targetDesc.isConfigurable()) {
                    throw ScriptRuntime.typeError("proxy can't define an incompatible property descriptor");
                }
                if (targetDesc.isDataDescriptor() && targetDesc.isConfigurable(false) && targetDesc.isWritable() && desc.isWritable(false)) {
                    throw ScriptRuntime.typeError("proxy can't define an incompatible property descriptor");
                }
            }
            return true;
        }
        return target.defineOwnProperty(cx, id, desc);
    }

    @Override
    public boolean isExtensible() {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_IS_EXTENSIBLE);
        if (trap == null) {
            return target.isExtensible();
        }
        boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target}));
        if (booleanTrapResult != target.isExtensible()) {
            throw ScriptRuntime.typeError("IsExtensible trap has to return the same value as the target");
        }
        return booleanTrapResult;
    }

    @Override
    public boolean preventExtensions() {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_PREVENT_EXTENSIONS);
        if (trap == null) {
            return target.preventExtensions();
        }
        boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target}));
        if (booleanTrapResult && target.isExtensible()) {
            throw ScriptRuntime.typeError("target is extensible but trap returned true");
        }
        return booleanTrapResult;
    }

    @Override
    public String getTypeOf() {
        return this.typeOf;
    }

    @Override
    public Scriptable getPrototype() {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_GET_PROTOTYPE_OF);
        if (trap != null) {
            Object handlerProto = this.callTrap(trap, new Object[]{target});
            Scriptable handlerProtoScriptable = Undefined.SCRIPTABLE_UNDEFINED;
            if (handlerProtoScriptable == null || Undefined.isUndefined(handlerProto) || ScriptRuntime.isSymbol(handlerProto)) {
                throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(handlerProto));
            }
            handlerProtoScriptable = NativeProxy.ensureScriptable(handlerProto);
            if (target.isExtensible()) {
                return handlerProtoScriptable;
            }
            if (handlerProto != target.getPrototype()) {
                throw ScriptRuntime.typeError("getPrototypeOf trap has to return the original prototype");
            }
            return handlerProtoScriptable;
        }
        return target.getPrototype();
    }

    private void setPrototypeDirect(Scriptable prototype) {
        super.setPrototype(prototype);
    }

    @Override
    public void setPrototype(Scriptable prototype) {
        ScriptableObject target = this.getTargetThrowIfRevoked();
        Function trap = this.getTrap(TRAP_SET_PROTOTYPE_OF);
        if (trap != null) {
            boolean booleanTrapResult = ScriptRuntime.toBoolean(this.callTrap(trap, new Object[]{target, prototype}));
            if (!booleanTrapResult) {
                return;
            }
            if (target.isExtensible()) {
                return;
            }
            return;
        }
        target.setPrototype(prototype);
    }

    private static NativeProxy constructor(Context cx, Scriptable scope, Object[] args) {
        if (args.length < 2) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Proxy.ctor", "2", Integer.toString(args.length));
        }
        ScriptableObject target = NativeProxy.ensureScriptableObjectButNotSymbol(args[0]);
        ScriptableObject handler = NativeProxy.ensureScriptableObjectButNotSymbol(args[1]);
        NativeProxy proxy = target instanceof Function ? new NativeProxyFunction(target, (Scriptable)handler) : new NativeProxy(target, (Scriptable)handler);
        proxy.setPrototypeDirect(ScriptableObject.getClassPrototype(scope, PROXY_TAG));
        proxy.setParentScope(scope);
        return proxy;
    }

    private static Object revocable(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!ScriptRuntime.isObject(thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(thisObj));
        }
        NativeProxy proxy = NativeProxy.constructor(cx, scope, args);
        NativeObject revocable = (NativeObject)cx.newObject(scope);
        revocable.put("proxy", (Scriptable)revocable, (Object)proxy);
        revocable.put("revoke", (Scriptable)revocable, (Object)new LambdaFunction(scope, "", 0, new Revoker(proxy)));
        return revocable;
    }

    protected final Function getTrap(String trapName) {
        Object handlerProp = ScriptableObject.getProperty(this.handlerObj, trapName);
        if (Scriptable.NOT_FOUND == handlerProp) {
            return null;
        }
        if (handlerProp == null || Undefined.isUndefined(handlerProp)) {
            return null;
        }
        if (!(handlerProp instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(handlerProp, trapName);
        }
        return (Function)handlerProp;
    }

    protected final Object callTrap(Function trap, Object[] args) {
        return trap.call(Context.getContext(), trap.getDeclarationScope(), this.handlerObj, args);
    }

    ScriptableObject getTargetThrowIfRevoked() {
        if (this.targetObj == null) {
            throw ScriptRuntime.typeError("Illegal operation attempted on a revoked proxy");
        }
        return this.targetObj;
    }

    static class NativeProxyFunction
    extends NativeProxy
    implements Function {
        NativeProxyFunction(ScriptableObject target, Scriptable handler) {
            super(target, handler);
        }

        @Override
        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            ScriptableObject target = this.getTargetThrowIfRevoked();
            Function trap = this.getTrap(NativeProxy.TRAP_CONSTRUCT);
            if (trap != null) {
                Object result = this.callTrap(trap, new Object[]{target, args, this});
                if (!(result instanceof Scriptable) || ScriptRuntime.isSymbol(result)) {
                    throw ScriptRuntime.typeError("Constructor trap has to return a scriptable.");
                }
                return (ScriptableObject)result;
            }
            return ((Constructable)((Object)target)).construct(cx, scope, args);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            ScriptableObject target = this.getTargetThrowIfRevoked();
            Scriptable argumentsList = cx.newArray(scope, args);
            Function trap = this.getTrap(NativeProxy.TRAP_APPLY);
            if (trap != null) {
                return this.callTrap(trap, new Object[]{target, thisObj, argumentsList});
            }
            return ScriptRuntime.applyOrCall(true, cx, scope, target, new Object[]{thisObj, argumentsList});
        }

        @Override
        public Scriptable getDeclarationScope() {
            ScriptableObject target = this.getTargetThrowIfRevoked();
            if (target instanceof Function) {
                return ((Function)((Object)target)).getDeclarationScope();
            }
            Kit.codeBug();
            return null;
        }
    }

    private static final class Revoker
    implements SerializableCallable {
        private NativeProxy revocableProxy = null;

        public Revoker(NativeProxy proxy) {
            this.revocableProxy = proxy;
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (this.revocableProxy != null) {
                this.revocableProxy.handlerObj = null;
                this.revocableProxy.targetObj = null;
                this.revocableProxy = null;
            }
            return Undefined.instance;
        }
    }
}

