/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HttpAcceptorHandler
extends ChannelDuplexHandler {
    private final BlockingQueue<FullHttpResponse> responses = new LinkedBlockingQueue<FullHttpResponse>();
    private final BlockingQueue<Runnable> delayedResponses = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.delayedResponses);
    private Channel channel;

    public HttpAcceptorHandler(Channel channel) {
        this.channel = channel;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.shutdown();
        this.channel = null;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        HttpMethod method = request.method();
        if (method.equals((Object)HttpMethod.POST)) {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)((FullHttpRequest)msg).content()));
            this.responses.put((FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK));
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            this.executor.execute(new ResponseRunner(buf, promise));
        } else {
            ctx.write(msg, promise);
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.executor.shutdownNow();
        }
        this.responses.clear();
    }

    final class ResponseRunner
    implements Runnable {
        private final ByteBuf buffer;
        private final boolean bogusResponse;
        private final ChannelPromise promise;

        ResponseRunner(ByteBuf buffer, ChannelPromise promise) {
            this.buffer = buffer;
            this.bogusResponse = false;
            this.promise = promise;
        }

        @Override
        public void run() {
            FullHttpResponse response = null;
            do {
                try {
                    response = HttpAcceptorHandler.this.responses.take();
                }
                catch (InterruptedException e) {
                    if (!HttpAcceptorHandler.this.executor.isShutdown()) continue;
                    return;
                }
            } while (response == null);
            if (!this.bogusResponse) {
                this.piggyBackResponses(response.content());
            } else {
                response.content().writeBytes(this.buffer);
            }
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(response.content().readableBytes()));
            HttpAcceptorHandler.this.channel.writeAndFlush((Object)response, this.promise);
            this.buffer.release();
        }

        private void piggyBackResponses(ByteBuf buf) {
            if (HttpAcceptorHandler.this.responses.isEmpty()) {
                buf.writeBytes(this.buffer);
                do {
                    try {
                        ResponseRunner responseRunner = (ResponseRunner)HttpAcceptorHandler.this.delayedResponses.poll(0L, TimeUnit.MILLISECONDS);
                        if (responseRunner == null) break;
                        buf.writeBytes(responseRunner.buffer);
                        responseRunner.buffer.release();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while (HttpAcceptorHandler.this.responses.isEmpty());
                return;
            }
            buf.writeBytes(this.buffer);
        }
    }
}

