/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.slf4j.Logger;

public class ChainingSignaturePrevalidator
implements SignaturePrevalidator {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ChainingSignaturePrevalidator.class);
    @Nonnull
    private List<SignaturePrevalidator> validators;

    public ChainingSignaturePrevalidator(@Nonnull @ParameterName(name="validatorChain") List<SignaturePrevalidator> validatorChain) {
        this.validators = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(validatorChain, (String)"SignaturePrevalidator list cannot be null")));
    }

    public void validate(@Nonnull Signature signature) throws SignatureException {
        for (SignaturePrevalidator validator : this.validators) {
            this.log.debug("Validating signature using prevalidator: {}", (Object)validator.getClass().getName());
            validator.validate(signature);
        }
    }
}

