/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio._private.Messages;
import org.xnio.channels.AssembledConnectedChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class AssembledSslChannel
extends AssembledConnectedChannel
implements SslChannel {
    private final SslChannel sslChannel;
    private final ChannelListener.Setter<AssembledSslChannel> handshakeSetter;

    public AssembledSslChannel(SuspendableReadChannel readChannel, SuspendableWriteChannel writeChannel) {
        super(readChannel, writeChannel);
        if (readChannel instanceof SslChannel) {
            this.sslChannel = (SslChannel)((Object)readChannel);
        } else if (writeChannel instanceof SslChannel) {
            this.sslChannel = (SslChannel)((Object)writeChannel);
        } else {
            throw Messages.msg.oneChannelMustBeSSL();
        }
        this.handshakeSetter = ChannelListeners.getDelegatingSetter(this.sslChannel.getHandshakeSetter(), this);
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslChannel.startHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslChannel.getSslSession();
    }

    public ChannelListener.Setter<? extends AssembledSslChannel> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    public ChannelListener.Setter<? extends AssembledSslChannel> getCloseSetter() {
        return super.getCloseSetter();
    }
}

