/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.common.logging.LogUtils;

public class SseEventSinkImpl
implements SseEventSink {
    public static final String BUFFER_SIZE_PROPERTY = "org.apache.cxf.sse.sink.buffer.size";
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final Logger LOG = LogUtils.getL7dLogger(SseEventSinkImpl.class);
    private static final int DEFAULT_BUFFER_SIZE = 10000;
    private final AsyncContext ctx;
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final Queue<QueuedEvent> buffer;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean dispatching = new AtomicBoolean(false);
    private final AtomicReference<Throwable> throwable = new AtomicReference();
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final int bufferSize;

    public SseEventSinkImpl(MessageBodyWriter<OutboundSseEvent> writer, AsyncResponse async, AsyncContext ctx) {
        this(writer, async, ctx, 10000);
    }

    public SseEventSinkImpl(MessageBodyWriter<OutboundSseEvent> writer, AsyncResponse async, AsyncContext ctx, int bufferSize) {
        this.writer = writer;
        this.buffer = new ArrayBlockingQueue<QueuedEvent>(bufferSize);
        this.ctx = ctx;
        this.bufferSize = bufferSize;
        if (ctx == null) {
            throw new IllegalStateException("Unable to retrieve the AsyncContext for this request. Is the Servlet configured properly?");
        }
        ctx.getResponse().setContentType("text/event-stream");
        ctx.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
                SseEventSinkImpl.this.close();
            }

            public void onTimeout(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
                if (SseEventSinkImpl.this.throwable.get() != null || SseEventSinkImpl.this.throwable.compareAndSet(null, event.getThrowable())) {
                    SseEventSinkImpl.this.close();
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
    }

    public AsyncContext getAsyncContext() {
        return this.ctx;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Throwable ex;
            LOG.fine("Closing SSE sink now");
            if (!this.awaitQueueToDrain(5, TimeUnit.SECONDS)) {
                LOG.warning("There are still SSE events the queue which may not be delivered (closing now)");
            }
            if (this.completed.compareAndSet(false, true)) {
                try {
                    if (this.ctx.getRequest() != null) {
                        LOG.fine("Completing the AsyncContext");
                        this.ctx.complete();
                    }
                }
                catch (IllegalStateException ex2) {
                    LOG.fine("Failed to close the AsyncContext cleanly: " + ex2.getMessage());
                }
            }
            if ((ex = this.throwable.get()) == null) {
                ex = new IllegalStateException("The sink has been already closed");
            }
            QueuedEvent queuedEvent = this.buffer.poll();
            while (queuedEvent != null) {
                queuedEvent.completion.completeExceptionally(ex);
                queuedEvent = this.buffer.poll();
            }
        }
    }

    private boolean awaitQueueToDrain(int timeout, TimeUnit unit) {
        long parkTime = unit.toNanos(timeout) / 20L;
        int attempt = 0;
        while (this.dispatching.get() && ++attempt < 20) {
            LockSupport.parkNanos(parkTime);
        }
        return this.buffer.isEmpty();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public CompletionStage<?> send(OutboundSseEvent event) {
        CompletableFuture future = new CompletableFuture();
        if (!this.closed.get() && this.writer != null) {
            Throwable ex = this.throwable.get();
            if (ex != null) {
                future.completeExceptionally(ex);
            } else if (this.buffer.offer(new QueuedEvent(event, future))) {
                if (this.dispatching.compareAndSet(false, true)) {
                    this.ctx.start(this::dequeue);
                }
            } else {
                future.completeExceptionally(new IllegalStateException("The buffer is full (" + this.bufferSize + "), unable to queue SSE event for send. Please use 'org.apache.cxf.sse.sink.buffer.size' property to increase the limit."));
            }
        } else {
            future.completeExceptionally(new IllegalStateException("The sink is already closed, unable to queue SSE event for send"));
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dequeue() {
        error = this.throwable.get();
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                block15: {
                    if ((queuedEvent = this.buffer.poll()) != null) break block15;
                    if (error != null) {
                        ** break;
                    }
                    ** GOTO lbl-1000
                }
                event = queuedEvent.event;
                future = queuedEvent.completion;
                try {
                    if (error == null) {
                        SseEventSinkImpl.LOG.fine("Dispatching SSE event over the wire");
                        this.writer.writeTo((Object)event, event.getClass(), event.getGenericType(), SseEventSinkImpl.EMPTY_ANNOTATIONS, event.getMediaType(), null, (OutputStream)this.ctx.getResponse().getOutputStream());
                        this.ctx.getResponse().flushBuffer();
                        SseEventSinkImpl.LOG.fine("Completing the future successfully");
                        future.complete(null);
                    }
                    SseEventSinkImpl.LOG.fine("Completing the future unsuccessfully (error enountered previously)");
                    future.completeExceptionally(error);
                }
                catch (Exception ex) {
                    if (ex instanceof IOException) {
                        error = (IOException)ex;
                    }
                    SseEventSinkImpl.LOG.fine("Completing the future unsuccessfully (error enountered)");
                    future.completeExceptionally(ex);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl32:
            // 1 sources

            if (this.throwable.compareAndSet(null, error)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        catch (Throwable var6_8) {
            shouldComplete = error != null && this.throwable.compareAndSet(null, error) != false;
            this.dispatching.set(false);
            if (shouldComplete == false) throw var6_8;
            if (this.completed.compareAndSet(false, true) == false) throw var6_8;
            SseEventSinkImpl.LOG.fine("Prematurely completing the AsyncContext due to error encountered: " + error);
            try {
                SseEventSinkImpl.LOG.fine("Completing the AsyncContext");
                if (this.ctx.getRequest() == null) throw var6_8;
                this.ctx.complete();
                throw var6_8;
            }
            catch (IllegalStateException ex) {
                SseEventSinkImpl.LOG.fine("Failed to close the AsyncContext cleanly: " + ex.getMessage());
            }
            throw var6_8;
        }
        shouldComplete = v0;
        this.dispatching.set(false);
        if (shouldComplete == false) return;
        if (this.completed.compareAndSet(false, true) == false) return;
        SseEventSinkImpl.LOG.fine("Prematurely completing the AsyncContext due to error encountered: " + error);
        try {
            SseEventSinkImpl.LOG.fine("Completing the AsyncContext");
            if (this.ctx.getRequest() == null) return;
            this.ctx.complete();
            return;
        }
        catch (IllegalStateException ex) {
            SseEventSinkImpl.LOG.fine("Failed to close the AsyncContext cleanly: " + ex.getMessage());
            return;
        }
    }

    private static class QueuedEvent {
        private final OutboundSseEvent event;
        private final CompletableFuture<?> completion;

        QueuedEvent(OutboundSseEvent event, CompletableFuture<?> completion) {
            this.event = event;
            this.completion = completion;
        }
    }
}

