/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.rat.OptionCollection;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.help.Licenses;

public final class Documentation {
    private Documentation() {
    }

    public static void main(String[] args) throws IOException {
        ReportConfiguration config = OptionCollection.parseCommands(new File("."), args, Documentation::printUsage, true);
        if (config != null) {
            try (Writer writer = config.getWriter().get();){
                new Licenses(config, writer).output();
            }
        }
    }

    private static void printUsage(Options opts) {
        HelpFormatter f = new HelpFormatter();
        f.setOptionComparator(OptionCollection.OPTION_COMPARATOR);
        f.setWidth(120);
        String header = "\nAvailable options";
        String footer = "";
        String cmdLine = String.format("java -jar apache-rat/target/apache-rat-CURRENT-VERSION.jar %s", Documentation.class.getName());
        f.printHelp(cmdLine, header, opts, footer, false);
        System.exit(0);
    }
}

