/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.tasks.VfsTask;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.tools.ant.BuildException;

public abstract class AbstractSyncTask
extends VfsTask {
    private final ArrayList<SourceInfo> srcFiles = new ArrayList();
    private String destFileUrl;
    private String destDirUrl;
    private String srcDirUrl;
    private boolean srcDirIsBase;
    private boolean failOnError = true;
    private String filesList;

    public void addConfiguredSrc(SourceInfo srcInfo) throws BuildException {
        if (srcInfo.file == null) {
            String message = Messages.getString((String)"vfs.tasks/sync.no-source-file.error");
            throw new BuildException(message);
        }
        this.srcFiles.add(srcInfo);
    }

    protected boolean detectMissingSourceFiles() {
        return false;
    }

    public void execute() throws BuildException {
        if (this.destFileUrl == null && this.destDirUrl == null) {
            String message = Messages.getString((String)"vfs.tasks/sync.no-destination.error");
            this.logOrDie(message, 1);
            return;
        }
        if (this.destFileUrl != null && this.destDirUrl != null) {
            String message = Messages.getString((String)"vfs.tasks/sync.too-many-destinations.error");
            this.logOrDie(message, 1);
            return;
        }
        if (this.srcDirUrl != null && !this.srcDirUrl.equals(this.destDirUrl) && this.filesList != null && this.filesList.length() > 0) {
            if (!this.srcDirUrl.endsWith("/")) {
                this.srcDirUrl = this.srcDirUrl + "/";
            }
            StringTokenizer tok = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
            while (tok.hasMoreTokens()) {
                String nextFile = tok.nextToken();
                if (nextFile.endsWith("/**")) {
                    nextFile = nextFile.substring(0, nextFile.length() - 2);
                }
                SourceInfo src = new SourceInfo();
                src.setFile(this.srcDirUrl + nextFile);
                this.addConfiguredSrc(src);
            }
        }
        if (this.srcFiles.isEmpty()) {
            String message = Messages.getString((String)"vfs.tasks/sync.no-source-files.warn");
            this.logOrDie(message, 1);
            return;
        }
        try {
            if (this.destFileUrl != null) {
                this.handleSingleFile();
            } else {
                this.handleFiles();
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void handleFile(FileObject srcFile, FileObject destFile) throws Exception {
        if (!FileObjectUtils.exists((FileObject)destFile) || srcFile.getContent().getLastModifiedTime() > destFile.getContent().getLastModifiedTime()) {
            this.handleOutOfDateFile(srcFile, destFile);
        } else {
            this.handleUpToDateFile(srcFile, destFile);
        }
    }

    private void handleFile(Set<FileObject> destFiles, FileObject srcFile, FileObject destFile) throws Exception {
        if (destFiles.contains(destFile)) {
            String message = Messages.getString((String)"vfs.tasks/sync.duplicate-source-files.warn", (Object)destFile);
            this.logOrDie(message, 1);
        } else {
            destFiles.add(destFile);
        }
        this.handleFile(srcFile, destFile);
    }

    private void handleFiles() throws Exception {
        FileObject destFolder = this.resolveFile(this.destDirUrl);
        destFolder.createFolder();
        FileName srcDirName = null;
        if (this.srcDirUrl != null) {
            srcDirName = this.resolveFile(this.srcDirUrl).getName();
        }
        ArrayList<FileObject> srcs = new ArrayList<FileObject>();
        for (SourceInfo sourceInfo : this.srcFiles) {
            FileObject srcFile = this.resolveFile(sourceInfo.file);
            if (!srcFile.exists()) {
                String message = Messages.getString((String)"vfs.tasks/sync.src-file-no-exist.warn", (Object)srcFile);
                this.logOrDie(message, 1);
                continue;
            }
            srcs.add(srcFile);
        }
        HashSet<FileObject> destFiles = new HashSet<FileObject>();
        for (FileObject rootFile : srcs) {
            FileObject files;
            FileName rootName = rootFile.getName();
            if (rootFile.isFile()) {
                String relName = srcDirName == null || !this.srcDirIsBase ? rootName.getBaseName() : srcDirName.getRelativeName(rootName);
                FileObject destFile = destFolder.resolveFile(relName, NameScope.DESCENDENT);
                this.handleFile(destFiles, rootFile, destFile);
                continue;
            }
            for (FileObject srcFile : files = rootFile.findFiles(this.srcDirIsBase ? Selectors.SELECT_ALL : Selectors.SELECT_FILES)) {
                String relName = srcDirName == null || !this.srcDirIsBase ? rootName.getRelativeName(srcFile.getName()) : srcDirName.getRelativeName(srcFile.getName());
                FileObject destFile = destFolder.resolveFile(relName, NameScope.DESCENDENT);
                this.handleFile(destFiles, srcFile, destFile);
            }
        }
        if (this.detectMissingSourceFiles()) {
            FileObject[] fileObjectArray;
            for (FileObject destFile : fileObjectArray = destFolder.findFiles(Selectors.SELECT_FILES)) {
                if (destFiles.contains(destFile)) continue;
                this.handleMissingSourceFile(destFile);
            }
        }
    }

    protected void handleMissingSourceFile(FileObject destFile) throws Exception {
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    private void handleSingleFile() throws Exception {
        if (this.srcFiles.size() > 1) {
            String message = Messages.getString((String)"vfs.tasks/sync.too-many-source-files.error");
            this.logOrDie(message, 1);
            return;
        }
        SourceInfo src = this.srcFiles.get(0);
        FileObject srcFile = this.resolveFile(src.file);
        if (!srcFile.isFile()) {
            String message = Messages.getString((String)"vfs.tasks/sync.source-not-file.error", (Object)srcFile);
            this.logOrDie(message, 1);
            return;
        }
        FileObject destFile = this.resolveFile(this.destFileUrl);
        this.handleFile(srcFile, destFile);
    }

    protected void handleUpToDateFile(FileObject srcFile, FileObject destFile) throws Exception {
    }

    public boolean isFailonerror() {
        return this.failOnError;
    }

    protected void logOrDie(String message, int level) {
        if (!this.isFailonerror()) {
            this.log(message, level);
            return;
        }
        throw new BuildException(message);
    }

    public void setDestDir(String destDirUrl) {
        this.destDirUrl = destDirUrl;
    }

    public void setDestFile(String destFileUrl) {
        this.destFileUrl = destFileUrl;
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setIncludes(String filesList) {
        this.filesList = filesList;
    }

    public void setSrc(String srcFile) {
        SourceInfo src = new SourceInfo();
        src.setFile(srcFile);
        this.addConfiguredSrc(src);
    }

    public void setSrcDir(String srcDirUrl) {
        this.srcDirUrl = srcDirUrl;
    }

    public void setSrcDirIsBase(boolean srcDirIsBase) {
        this.srcDirIsBase = srcDirIsBase;
    }

    public static class SourceInfo {
        private String file;

        public void setFile(String file) {
            this.file = file;
        }
    }
}

