/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.HiddenFileFilter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class HiddenFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File visibleFile;
    private static FileSelectInfo visibleFileInfo;
    private static File hiddenFile;
    private static FileSelectInfo hiddenFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterAll
    public static void afterClass() throws IOException {
        visibleFile = null;
        visibleFileInfo = null;
        hiddenFile = null;
        hiddenFileInfo = null;
        notExistingFile = null;
        notExistingFileInfo = null;
        IOUtils.close((Closeable)zipFileObj);
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeAll
    public static void beforeClass() throws IOException {
        testDir = HiddenFileFilterTest.getTestDir(HiddenFileFilterTest.class.getName());
        testDir.mkdir();
        visibleFile = new File(testDir, "visible.txt");
        FileUtils.touch((File)visibleFile);
        visibleFileInfo = HiddenFileFilterTest.createFileSelectInfo(visibleFile);
        hiddenFile = new File(testDir, "hidden.txt");
        hiddenFileInfo = HiddenFileFilterTest.createFileSelectInfo(hiddenFile);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = HiddenFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(HiddenFileFilterTest.getTempDir(), HiddenFileFilterTest.class.getName() + ".zip");
        HiddenFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = HiddenFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptHidden() throws FileSystemException {
        FileFilter testee = HiddenFileFilter.HIDDEN;
        Assertions.assertFalse((boolean)testee.accept(visibleFileInfo));
        Assertions.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptVisible() throws FileSystemException {
        FileFilter testee = HiddenFileFilter.VISIBLE;
        Assertions.assertTrue((boolean)testee.accept(visibleFileInfo));
        Assertions.assertTrue((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(HiddenFileFilter.VISIBLE));
        this.assertContains(files, visibleFile.getName());
        Assertions.assertEquals((int)1, (int)files.length);
    }
}

