/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.release.plugin.mojos;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.release.plugin.SharedFunctions;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="clean-staging", defaultPhase=LifecyclePhase.POST_CLEAN, threadSafe=true, aggregator=true)
public class CommonsStagingCleanupMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin", property="commons.outputDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="${project.build.directory}/commons-release-plugin/scm-cleanup", property="commons.distCleanupDirectory")
    private File distCleanupDirectory;
    @Parameter(property="commons.release.dryRun", defaultValue="false")
    private Boolean dryRun;
    @Parameter(defaultValue="", property="commons.distSvnStagingUrl")
    private String distSvnStagingUrl;
    @Parameter(defaultValue="false", property="commons.release.isDistModule")
    private Boolean isDistModule;
    @Parameter(property="commons.distServer")
    private String distServer;
    @Parameter(property="user.name")
    private String username;
    @Parameter(property="user.password")
    private String password;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isDistModule.booleanValue()) {
            this.getLog().info((CharSequence)"This module is marked as a non distribution or assembly module, and the plugin will not run.");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.distSvnStagingUrl)) {
            this.getLog().warn((CharSequence)"commons.distSvnStagingUrl is not set, the commons-release-plugin will not run.");
            return;
        }
        if (!this.workingDirectory.exists()) {
            SharedFunctions.initDirectory(this.getLog(), this.workingDirectory);
        }
        try {
            BasicScmManager scmManager = new BasicScmManager();
            scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
            ScmRepository repository = scmManager.makeScmRepository(this.distSvnStagingUrl);
            ScmProvider provider = scmManager.getProviderByRepository(repository);
            SvnScmProviderRepository providerRepository = (SvnScmProviderRepository)repository.getProviderRepository();
            SharedFunctions.setAuthentication((ScmProviderRepository)providerRepository, this.distServer, this.settings, this.settingsDecrypter, this.username, this.password);
            this.getLog().info((CharSequence)("Checking out dist from: " + this.distSvnStagingUrl));
            ScmFileSet scmFileSet = new ScmFileSet(this.distCleanupDirectory);
            CheckOutScmResult checkOutResult = provider.checkOut(repository, scmFileSet);
            if (!checkOutResult.isSuccess()) {
                throw new MojoExecutionException("Failed to checkout files from SCM: " + checkOutResult.getProviderMessage() + " [" + checkOutResult.getCommandOutput() + "]");
            }
            List<File> filesToRemove = Arrays.asList(this.distCleanupDirectory.listFiles());
            if (filesToRemove.size() == 1) {
                this.getLog().info((CharSequence)"No files to delete");
                return;
            }
            if (!this.dryRun.booleanValue()) {
                ScmFileSet fileSet = new ScmFileSet(this.distCleanupDirectory, filesToRemove);
                RemoveScmResult removeScmResult = provider.remove(repository, fileSet, "Cleaning up staging area");
                if (!removeScmResult.isSuccess()) {
                    throw new MojoFailureException("Failed to remove files from SCM: " + removeScmResult.getProviderMessage() + " [" + removeScmResult.getCommandOutput() + "]");
                }
                this.getLog().info((CharSequence)("Cleaning distribution area for: " + this.project.getArtifactId()));
                CheckInScmResult checkInResult = provider.checkIn(repository, fileSet, "Cleaning distribution area for: " + this.project.getArtifactId());
                if (!checkInResult.isSuccess()) {
                    throw new MojoFailureException("Failed to commit files: " + removeScmResult.getProviderMessage() + " [" + removeScmResult.getCommandOutput() + "]");
                }
            } else {
                this.getLog().info((CharSequence)("Would have attempted to delete files from: " + this.distSvnStagingUrl));
            }
        }
        catch (ScmException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

