/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.io.channels.AbstractSeekableByteChannelTest;
import org.apache.commons.io.channels.ByteArraySeekableByteChannel;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteArraySeekableByteChannelTest
extends AbstractSeekableByteChannelTest {
    private static final byte[] testData = "Some data".getBytes(StandardCharsets.UTF_8);

    static Stream<Arguments> testConstructor() {
        return Stream.of(Arguments.of((Object[])new Object[]{ByteArraySeekableByteChannel::new, ArrayUtils.EMPTY_BYTE_ARRAY, 8192}), Arguments.of((Object[])new Object[]{() -> new ByteArraySeekableByteChannel(8), ArrayUtils.EMPTY_BYTE_ARRAY, 8}), Arguments.of((Object[])new Object[]{() -> new ByteArraySeekableByteChannel(16), ArrayUtils.EMPTY_BYTE_ARRAY, 16}), Arguments.of((Object[])new Object[]{() -> ByteArraySeekableByteChannel.wrap((byte[])ArrayUtils.EMPTY_BYTE_ARRAY), ArrayUtils.EMPTY_BYTE_ARRAY, 0}), Arguments.of((Object[])new Object[]{() -> ByteArraySeekableByteChannel.wrap((byte[])testData), testData, testData.length}));
    }

    static Stream<Arguments> testShouldResizeWhenWritingMoreDataThanCapacity() {
        return Stream.of(Arguments.of((Object[])new Object[]{ArrayUtils.EMPTY_BYTE_ARRAY, 1}), Arguments.of((Object[])new Object[]{new byte[8], 1}), Arguments.of((Object[])new Object[]{new byte[8], 20}));
    }

    @Override
    protected SeekableByteChannel createChannel() throws IOException {
        return new ByteArraySeekableByteChannel();
    }

    @ParameterizedTest
    @MethodSource
    void testConstructor(IOSupplier<ByteArraySeekableByteChannel> supplier, byte[] expected, int capacity) throws IOException {
        try (ByteArraySeekableByteChannel channel = (ByteArraySeekableByteChannel)supplier.get();){
            Assertions.assertEquals((long)0L, (long)channel.position());
            Assertions.assertEquals((long)expected.length, (long)channel.size());
            Assertions.assertEquals((int)capacity, (int)channel.array().length);
            Assertions.assertArrayEquals((byte[])expected, (byte[])channel.toByteArray());
        }
    }

    @Test
    void testConstructorInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteArraySeekableByteChannel(-1));
        Assertions.assertThrows(NullPointerException.class, () -> ByteArraySeekableByteChannel.wrap(null));
    }

    @ParameterizedTest
    @MethodSource
    void testShouldResizeWhenWritingMoreDataThanCapacity(byte[] data, int wanted) throws IOException {
        try (ByteArraySeekableByteChannel c = ByteArraySeekableByteChannel.wrap((byte[])data);){
            c.position((long)data.length);
            ByteBuffer inData = ByteBuffer.wrap(new byte[wanted]);
            int writeCount = c.write(inData);
            Assertions.assertEquals((int)wanted, (int)writeCount);
            Assertions.assertTrue((c.array().length >= data.length + wanted ? 1 : 0) != 0, (String)"Capacity not increased sufficiently");
        }
    }
}

