/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class BinaryFragmentToJsonTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        String inputFile;
        Schema schema;
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder noPrettyOption = optionParser.accepts("no-pretty", "Turns off pretty printing.");
        ArgumentAcceptingOptionSpec schemaFileOption = optionParser.accepts("schema-file", "File containing schema, must not occur with inline schema.").withOptionalArg().ofType(String.class);
        OptionSet optionSet = optionParser.parse(args.toArray(new String[0]));
        Boolean noPretty = optionSet.has((OptionSpec)noPrettyOption);
        List nargs = optionSet.nonOptionArguments();
        String schemaFile = (String)schemaFileOption.value(optionSet);
        if (nargs.size() != (schemaFile == null ? 2 : 1)) {
            err.println("fragtojson --no-pretty --schema-file <file> [inline-schema] input-file");
            err.println("   converts Avro fragments to JSON.");
            optionParser.printHelpOn((OutputStream)err);
            err.println("   A dash '-' for input-file means stdin.");
            return 1;
        }
        if (schemaFile == null) {
            schema = new Schema.Parser().parse((String)nargs.get(0));
            inputFile = (String)nargs.get(1);
        } else {
            schema = Util.parseSchemaFromFS(schemaFile);
            inputFile = (String)nargs.get(0);
        }
        BufferedInputStream input = Util.fileOrStdin(inputFile, stdin);
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder((InputStream)input, null);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out, noPretty == false);
            Object datum = null;
            while (!binaryDecoder.isEnd()) {
                datum = reader.read(datum, (Decoder)binaryDecoder);
                writer.write(datum, (Encoder)jsonEncoder);
                jsonEncoder.flush();
            }
            out.println();
            out.flush();
        }
        finally {
            Util.close(input);
        }
        return 0;
    }

    @Override
    public String getName() {
        return "fragtojson";
    }

    @Override
    public String getShortDescription() {
        return "Renders a binary-encoded Avro datum as JSON.";
    }
}

