/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Series;
import org.musicbrainz.mmd2.SeriesList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.SeriesIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class SeriesWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        SeriesList seriesList = of.createSeriesList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(seriesList.getSeries(), results);
        seriesList.setCount(BigInteger.valueOf(results.getTotalHits()));
        seriesList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setSeriesList(seriesList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Series series = (Series)MMDSerializer.unserialize((String)doc.get((IndexField)SeriesIndexField.SERIES_STORE), Series.class);
        series.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(series);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getSeriesList().getSeries().size() > 0) {
            for (Series series : metadata.getSeriesList().getSeries()) {
                if (series.getAliasList() == null) continue;
                for (Alias alias : series.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

