﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class StartRestoreJobResult {
 public:
  AWS_BACKUP_API StartRestoreJobResult() = default;
  AWS_BACKUP_API StartRestoreJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API StartRestoreJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Uniquely identifies the job that restores a recovery point.</p>
   */
  inline const Aws::String& GetRestoreJobId() const { return m_restoreJobId; }
  template <typename RestoreJobIdT = Aws::String>
  void SetRestoreJobId(RestoreJobIdT&& value) {
    m_restoreJobIdHasBeenSet = true;
    m_restoreJobId = std::forward<RestoreJobIdT>(value);
  }
  template <typename RestoreJobIdT = Aws::String>
  StartRestoreJobResult& WithRestoreJobId(RestoreJobIdT&& value) {
    SetRestoreJobId(std::forward<RestoreJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartRestoreJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_restoreJobId;
  bool m_restoreJobIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
