/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.Field;
import io.protostuff.runtime.FieldMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HashFieldMap<T>
implements FieldMap<T> {
    private static final FieldComparator FIELD_COMPARATOR = new FieldComparator();
    private final List<Field<T>> fields;
    private final Map<Integer, Field<T>> fieldsByNumber;
    private final Map<String, Field<T>> fieldsByName = new HashMap<String, Field<T>>();

    public HashFieldMap(Collection<Field<T>> fields) {
        this.fieldsByNumber = new HashMap<Integer, Field<T>>();
        for (Field<T> f : fields) {
            if (this.fieldsByName.containsKey(f.name)) {
                Field<T> prev = this.fieldsByName.get(f.name);
                throw new IllegalStateException(prev + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber.containsKey(f.number)) {
                Field<T> prev = this.fieldsByNumber.get(f.number);
                throw new IllegalStateException(prev + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber.put(f.number, f);
            this.fieldsByName.put(f.name, f);
        }
        ArrayList<Field<T>> fieldList = new ArrayList<Field<T>>(fields.size());
        fieldList.addAll(fields);
        Collections.sort(fieldList, FIELD_COMPARATOR);
        this.fields = Collections.unmodifiableList(fieldList);
    }

    @Override
    public Field<T> getFieldByNumber(int n) {
        return this.fieldsByNumber.get(n);
    }

    @Override
    public Field<T> getFieldByName(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public List<Field<T>> getFields() {
        return this.fields;
    }

    private static class FieldComparator
    implements Comparator<Field<?>> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field<?> o1, Field<?> o2) {
            return FieldComparator.compare(o1.number, o2.number);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

