/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.models.PathItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openapitools.openapidiff.core.compare.OpenApiDiffOptions;

public class DiffContext {
    @JsonIgnore
    private final OpenApiDiffOptions options;
    private String url;
    private Map<String, String> parameters;
    private PathItem.HttpMethod method;
    private boolean response;
    private boolean request;
    private Boolean required;
    private String leftUrl;
    private String rightUrl;

    public DiffContext(OpenApiDiffOptions options) {
        this.options = options;
        this.parameters = new HashMap<String, String>();
        this.response = false;
        this.request = true;
    }

    public DiffContext copyWithMethod(PathItem.HttpMethod method) {
        return this.copy().setMethod(method);
    }

    public DiffContext copyWithRequired(boolean required) {
        return this.copy().setRequired(required);
    }

    public DiffContext copyAsRequest() {
        return this.copy().setRequest();
    }

    public DiffContext copyAsResponse() {
        return this.copy().setResponse();
    }

    public DiffContext copyWithLeftRightUrls(String leftUrl, String rightUrl) {
        return this.copy().setLeftAndRightUrls(leftUrl, rightUrl);
    }

    @JsonIgnore
    public OpenApiDiffOptions getOptions() {
        return this.options;
    }

    @JsonIgnore
    public Configuration getConfig() {
        return this.options.getConfig();
    }

    private DiffContext setRequest() {
        this.request = true;
        this.response = false;
        return this;
    }

    private DiffContext setResponse() {
        this.response = true;
        this.request = false;
        return this;
    }

    public boolean isResponse() {
        return this.response;
    }

    public boolean isRequest() {
        return this.request;
    }

    public String getUrl() {
        return this.url;
    }

    public DiffContext setUrl(String url) {
        this.url = url;
        return this;
    }

    public PathItem.HttpMethod getMethod() {
        return this.method;
    }

    private DiffContext setMethod(PathItem.HttpMethod method) {
        this.method = method;
        return this;
    }

    private DiffContext copy() {
        DiffContext context = new DiffContext(this.options);
        context.url = this.url;
        context.parameters = this.parameters;
        context.method = this.method;
        context.response = this.response;
        context.request = this.request;
        context.required = this.required;
        return context;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public DiffContext setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isRequired() {
        return this.required;
    }

    private DiffContext setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public DiffContext setLeftAndRightUrls(String leftUrl, String rightUrl) {
        this.leftUrl = leftUrl;
        this.rightUrl = rightUrl;
        return this;
    }

    public String getLeftUrl() {
        return this.leftUrl;
    }

    public String getRightUrl() {
        return this.rightUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffContext that = (DiffContext)o;
        return new EqualsBuilder().append(this.response, that.response).append(this.request, that.request).append(this.url, that.url).append(this.parameters, that.parameters).append((Object)this.method, (Object)that.method).append(this.required, that.required).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.url).append(this.parameters).append((Object)this.method).append(this.response).append(this.request).append(this.required).append(this.leftUrl).append(this.rightUrl).toHashCode();
    }
}

