/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.util.concurrent.atomic.LongAdder;

public class NetworkMetrics
implements TCPMetrics<LongTaskTimer.Sample> {
    final MeterRegistry registry;
    final DistributionSummary received;
    final DistributionSummary sent;
    final Meter.MeterProvider<Counter> exceptionCounter;
    final Gauge activeConnections;
    final Tags tags;
    private final LongTaskTimer connDuration;
    private final LongAdder connCount;

    public NetworkMetrics(MeterRegistry registry, Tags tags, String prefix, String receivedDesc, String sentDesc, String connDurationDesc, String connCountDesc) {
        this.registry = registry;
        this.tags = tags == null ? Tags.empty() : tags;
        this.connCount = new LongAdder();
        this.received = DistributionSummary.builder((String)(prefix + ".bytes.read")).description(receivedDesc).tags((Iterable)this.tags).register(registry);
        this.sent = DistributionSummary.builder((String)(prefix + ".bytes.written")).description(sentDesc).tags((Iterable)this.tags).register(registry);
        this.connDuration = LongTaskTimer.builder((String)(prefix + ".connections")).description(connDurationDesc).tags((Iterable)this.tags).register(registry);
        this.exceptionCounter = Counter.builder((String)(prefix + ".errors")).withRegistry(registry);
        this.activeConnections = Gauge.builder((String)(prefix + ".active.connections"), (Object)this.connCount, LongAdder::longValue).description(connCountDesc).tags((Iterable)this.tags).register(registry);
    }

    public LongTaskTimer.Sample connected(SocketAddress remoteAddress, String remoteName) {
        this.connCount.increment();
        return this.connDuration.start();
    }

    public void disconnected(LongTaskTimer.Sample sample, SocketAddress remoteAddress) {
        this.connCount.decrement();
        if (sample == null) {
            return;
        }
        sample.stop();
    }

    public void bytesRead(LongTaskTimer.Sample sample, SocketAddress remoteAddress, long numberOfBytes) {
        this.received.record((double)numberOfBytes);
    }

    public void bytesWritten(LongTaskTimer.Sample sample, SocketAddress remoteAddress, long numberOfBytes) {
        this.sent.record((double)numberOfBytes);
    }

    public void exceptionOccurred(LongTaskTimer.Sample sample, SocketAddress remoteAddress, Throwable t) {
        ((Counter)this.exceptionCounter.withTags((Iterable)this.tags.and(new Tag[]{Tag.of((String)"class", (String)t.getClass().getName())}))).increment();
    }

    public static String toString(SocketAddress remoteAddress) {
        String h;
        if (remoteAddress.isDomainSocket()) {
            return "unix://" + remoteAddress.path();
        }
        String string = h = remoteAddress.hostName() == null ? remoteAddress.host() : remoteAddress.hostName();
        if (remoteAddress.port() > 0) {
            return h + ":" + remoteAddress.port();
        }
        return h;
    }
}

