/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;

public interface RoleModel {
    public String getName();

    public String getDescription();

    public void setDescription(String var1);

    public String getId();

    public void setName(String var1);

    public boolean isComposite();

    public void addCompositeRole(RoleModel var1);

    public void removeCompositeRole(RoleModel var1);

    default public Stream<RoleModel> getCompositesStream() {
        return this.getCompositesStream(null, null, null);
    }

    public Stream<RoleModel> getCompositesStream(String var1, Integer var2, Integer var3);

    public boolean isClientRole();

    public String getContainerId();

    public RoleContainerModel getContainer();

    public boolean hasRole(RoleModel var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    default public String getFirstAttribute(String name) {
        return this.getAttributeStream(name).findFirst().orElse(null);
    }

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public static interface RoleRevokedEvent
    extends RoleEvent {
        public static void fire(final RoleModel role, final UserModel user, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new RoleRevokedEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public RoleModel getRole() {
                    return role;
                }

                @Override
                public UserModel getUser() {
                    return user;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }

        public UserModel getUser();
    }

    public static interface RoleGrantedEvent
    extends RoleEvent {
        public static void fire(final RoleModel role, final UserModel user, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new RoleGrantedEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public RoleModel getRole() {
                    return role;
                }

                @Override
                public UserModel getUser() {
                    return user;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }

        public UserModel getUser();
    }

    public static interface RoleEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public RoleModel getRole();

        @Override
        public KeycloakSession getKeycloakSession();
    }

    public static interface RoleNameChangeEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public String getNewName();

        public String getPreviousName();

        public String getClientId();

        @Override
        public KeycloakSession getKeycloakSession();
    }
}

