/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_make.h 125 2009-11-19 14:17:38Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_DLG_MAKE
#define H_LOADED_DLG_MAKE

#include <wx/spinctrl.h>
#include <wx/notebook.h>

WX_DECLARE_OBJARRAY(TPI_FORMATINFO, ArrayTPI_FORMATINFO);

//******************************************************************************
//    Class (MakeDialog)
//******************************************************************************

class MakeDialog: public wxDialog {
public:
	// "General"^u
    wxComboBox* cbDir;
    wxComboBox* cbFileName;
    wxCheckBox* cbOpenAfter;
    wxCheckBox* cbIgnorePath;
    wxCheckBox* cbExitAfter;
	wxChoice* chType;
	wxChoice* chDirMake;
	// "Config"^u
	wxSpinCtrl* scLevel;
	wxSpinCtrl* scRR;
	wxTextCtrl* tcPassword;
	wxTextCtrl* tcKeyfile;
    wxComboBox* cbSplitSize;
    wxCheckBox* cbUnmask;
    wxCheckBox* cbEncryptHeader;
    wxCheckBox* cbSolid;
    wxCheckBox* cbMMOptimize;
	wxCheckBox* cbMakeSFX;
	// "Comment"^u
	wxTextCtrl* tcComment;
	// "Files"^u
	wxListCtrl* lcFiles;

	ArrayTPI_FORMATINFO afInfo;
	wxArrayString files;
	bool bIsMake;

	MakeDialog();

	// Event handler.
    void OnInit(     wxInitDialogEvent&);
    void OnBtnDefault(  wxCommandEvent&);
    void OnBtnDesktop(  wxCommandEvent&);
    void OnBtnCurrent(  wxCommandEvent&);
    void OnBtnBrowse(   wxCommandEvent&);
    void OnBtnBrowseKF( wxCommandEvent&);
    void OnBtnOK(       wxCommandEvent&);
    void OnBtnCancel(   wxCommandEvent&);
    void OnChoice(      wxCommandEvent&);
    void OnCbUnmask(    wxCommandEvent&);
    void OnTabChanged( wxNotebookEvent&);

    DECLARE_EVENT_TABLE()
};

#endif
