/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: TPIHandle.h 125 2009-11-19 14:17:38Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_TPI_HANDLE
#define H_LOADED_TPI_HANDLE

#define wxUSE_DYNLIB_CLASS  1
#include <wx/dynlib.h>

//******************************************************************************
//    Class (TPIHandle)
//******************************************************************************

class TPIHandle
{
	public:
		TPIHandle(void);
		~TPIHandle(void);
		bool InitLibrary(const wxString &, const wxString &, wxULongLong);
		bool FreeLibrary(void);

		bool GetPluginInformation(unsigned int, wxULongLong, void *);
		bool GetFormatInformation(TPI_FORMATINFO *, bool);

		bool CheckArchive(const wxString &, int *);
		bool OpenArchive(const wxString &);
		bool CloseArchive(void);
		bool GetFileInformation(TPI_FILEINFO *, bool);
		bool GetArchiveInformation(TPI_ARCHIVEINFO *);

		bool Command(unsigned int, TPI_SWITCHES *, const wxString &, const wxArrayString &);

		bool SetCallbackProc(TPI_PROC);

		int nErrorCode;

	private:
		wxDynamicLibrary lib;
		void * archive;
};

#endif
