//
//  VTVerticalGlyphSubstitution.m
//  Manuscript
//
//  Created by 二鏡 on 12/01/30.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//

#import "VTVerticalGlyphSubstitution.h"
#import "OpenType.h"

static NSMutableDictionary *_table;

static void
map_insert_(uint16_t src, uint16_t dst, void *map);


static void
map_insert_(uint16_t src, uint16_t dst, void *map)
{
    ((OT_GSUBSingleGlyphMap*)map)->insert(src, dst);
}

@implementation VTVerticalGlyphSubstitution
{
    OT_GSUBSingleGlyphMap *map;
}

+ (void)initialize
{
    if(self == [VTVerticalGlyphSubstitution class])
        _table = [[NSMutableDictionary alloc] init];
}

- (id)initWithFont:(NSFont*)aFont
{
    CFDataRef GSUBtable = CTFontCopyTable((CTFontRef)aFont, kCTFontTableGSUB, kCTFontTableOptionExcludeSynthetic);
    if(GSUBtable == nil)
    {
        [self release];
        return nil;
    }
    
    OT_GSUBReader *reader = new OT_GSUBReader(GSUBtable);
    CFRelease(GSUBtable);
    
    OT_Feature *feature = reader->load_feature_by_tag('vrt2');
    if(feature == NULL)
    {
        feature = reader->load_feature_by_tag('vert');
        if(feature == NULL)
        {
            // 縦書きfeatureが存在しない
            delete reader;
            [self release];
            return nil;
        }
    }
    
    map = new OT_GSUBSingleGlyphMap();
    int count = feature->get_count();
    for(int i=0;i<count;i++)
    {
        // ヒモ付けられたlookupを巡る
        int lookup_index = feature->get_lookup_index(i);
        OT_Lookup *lookup = reader->load_lookup_by_index(lookup_index);
        
        // サブテーブルを集約
        int count = lookup->get_subtable_count();
        for(int i=0;i<count;i++)
        {
            OT_Substitution *subst = reader->load_substitution(lookup, i);
            if(subst)
            {
                subst->iterate_single_lookup(map_insert_, map);
                delete subst;
            }
        }
        delete lookup;
    }
    
    delete feature;
    delete reader;

    return self;
}

+ (id)verticalGlyphSubstitutionWithFont:(NSFont*)aFont
{
    @synchronized(self)
    {
        NSString *fontName = [aFont fontName];
        id subst = [_table objectForKey: fontName];
        if(subst)
            return subst;
        
        subst = [[[VTVerticalGlyphSubstitution alloc] initWithFont: aFont] autorelease];
        if(subst)
        {
            [_table setObject: subst forKey: fontName];
            return subst;
        }
    }   
    return nil;
}

- (void)substituteGlyphs:(CGGlyph*)glyphs count:(CFIndex)count
{
    for(CFIndex i=0;i<count;i++)
    {
        glyphs[i] = map->find(glyphs[i]);
        
    }
}

@end
