/*
 *  StandardCharacterSet.c
 *  Manuscript
 *
 *  Created by 二鏡 on 11/03/23.
 *  Copyright 2011 二鏡庵工房. All rights reserved.
 *
 */

#include "StandardCharacterSet.h"

static inline CFRange
CFRangeMakeEx(CFIndex start, CFIndex end)
{
    return CFRangeMake(start, end-start);    
}

CFCharacterSetRef CreateFullWidthCharacterSet(void)
{
    CFMutableCharacterSetRef set = CFCharacterSetCreateMutable(kCFAllocatorDefault);
    
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x4e00,0x9fff));   // CJK
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3400,0x4dbf));   // CJK Ex A
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x20000,0x2a6df)); // CJK Ex B
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x2a700,0x2b81f)); // CJK Ex C&D
    
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x2e80,0x2eff));   // CJK radicals
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x2ff0,0x2fff));   // CJK desc
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3000,0x303f));   // CJK symbols..
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3040,0x309f));   // Hiragana
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x30a0,0x30ff));   // Katakana
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3100,0x312f));
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3130,0x318f));   // Hangle 1
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x1000,0x11ff));   // Hangle 2
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0xac00,0xd7af));   // Hangle 3
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3200,0x32ff));
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0x3300,0x33ff));
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0xf900,0xfaff));
    CFCharacterSetAddCharactersInRange(set, CFRangeMakeEx(0xff00,0xff60));
    
    CFDataRef bitmap = CFCharacterSetCreateBitmapRepresentation(kCFAllocatorDefault, set);
    CFCharacterSetRef ret = CFCharacterSetCreateWithBitmapRepresentation(kCFAllocatorDefault, bitmap);
    CFRelease(set);
    CFRelease(bitmap);
    
    return ret;
}

CFStringRef JISHeadProhibitionCharacters = CFSTR(",)]｝、〕〉》」』】〙〗〟’”｠»ヽヾーァィゥェォッャュョヮヵヶぁぃぅぇぉっゃゅょゎゕゖㇰㇱㇲㇳㇴㇵㇶㇷㇸㇹㇺㇻㇼㇽㇾㇿ々〻‐゠–〜?!‼⁇⁈⁉・:;。.");

CFStringRef JISTailProhibitionCharacters = CFSTR("([｛〔〈《「『【〘〖〝‘“｟«");
