#ifndef HEADER_PSYCHLOPS_GRAPHIC_GENERIC_CACHE
#define HEADER_PSYCHLOPS_GRAPHIC_GENERIC_CACHE

#include <vector>
#include <string>

#include "../../core/graphic/psychlops_g_image.h"
#include "../../core/graphic/psychlops_g_font.h"


namespace Psychlops {
namespace Utilities {


	class CacheOnImage
	{
		public:
		bool dirty_;
		double font_size;
		Image img;
		CacheOnImage();
		~CacheOnImage();
		void dirty();
		void uncache();

		void draw(
			Letters &drawee, const double xx, const double yy,
			const double r, const double g, const double b, const double a,
			const int horiz_align, const int vertical_align, const double max_width, Drawable &outer);
	};

	class TextCacheManager
	{
		public:
		std::map<Letters*, CacheOnImage *> map;
		bool isCached(Letters *letters);

		void cache(Letters *letters, CacheOnImage *allocation);
		void uncache(Letters *letters);
		void uncacheAll();
	};

}
}	/*	<- namespace Psycholops 	*/

#endif

