/***************************************************************************
* $Id: Biff.java 274117 2003-12-21 05:47:45Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;
import java.util.Calendar;

class Biff extends QWidget
{
private    Calendar	lastModified;
private    QPixmap	hasNewMail = new QPixmap();
private    QPixmap	noNewMail = new QPixmap();
private    String	mailbox;
private    boolean	gotMail;

public Biff(  )
{
	this(null, null);
}
public Biff( QWidget parent, String name )
{
    super( parent, name, WType_Modal );
//    QFileInfo fi = new QFileInfo(System.getProperty("MAIL"));
    QFileInfo fi = new QFileInfo("");
    if ( !fi.exists() ) {
	String s = "/var/spool/mail/";
	s += System.getProperty("user.name");
	fi.setFile( s );
    }
    if ( fi.exists() ) {
	mailbox = fi.absFilePath();
	startTimer( 1000 );
    }

    setMinimumSize( 48, 48 );
    setMaximumSize( 48, 48 );
    resize( 48, 48 );

    hasNewMail.loadFromData( bmp.hasmail_bmp_data );
    noNewMail.loadFromData( bmp.nomail_bmp_data );

    gotMail = false;
    lastModified = fi.lastModified();
}


protected void timerEvent( QTimerEvent event )
{
    QFileInfo fi = new QFileInfo( mailbox );
    boolean newState = ( fi.lastModified() != lastModified &&
		      fi.lastModified().after( fi.lastRead() ) );
    if ( newState != gotMail ) {
	if ( gotMail )
	    lastModified = fi.lastModified();
	gotMail = newState;
	repaint( false );
    }
}
    

protected void paintEvent( QPaintEvent event )
{
    if ( gotMail )
	bitBlt( this, 0, 0, hasNewMail );
    else
	bitBlt( this, 0, 0, noNewMail );
}


protected void mousePressEvent( QMouseEvent event  )
{
    QFileInfo fi = new QFileInfo( mailbox );
    lastModified = fi.lastModified();
}
}
