#ifdef USE_SMB_BRANCH
#ifndef __SMB_MODULE__H_
#define __SMB_MODULE__H_
#include <gtk/gtk.h>
#include <gmodule.h>
#include "constants.h"
#include "types.h"

typedef struct xfsmb_functions {
    int (*open_smb)(		GtkTreeView * treeview,
				GtkTreeIter * iter, 	
				GtkTreePath * treepath, 
				gpointer user_data);
    void (*SMBGetFile) (	GtkTreeView *treeview, 
				char *target,
				GList *list);
    void (*SMBDropFile) (	GtkTreeView *treeview,
				tree_entry_t *t_en, 
				GtkTreeIter *iter,
				char *tmpfile);
    GList *(*SMBrmFile) (	GtkTreeView *treeview,
				char *remote_location,
				char *remote_pass,
				char *tmpfile,
				GList *reference_list);
    void (*SMBmkdir) (		GtkTreeView *treeview,
				tree_entry_t *t_en,
				GtkTreeIter *iter,
				gchar *newdir);   
    int (*SMBwait) (		gboolean animate);
    const gchar *
    (*SMBget_cache_file)(	GtkTreeView *treeview,
				tree_entry_t *en);
    const gchar *
    (*SMBget_netfile_cache_dir)(void);
}xfsmb_functions;

#define XF_open_smb (*(load_smb_module()->open_smb))
#define XF_SMBGetFile (*(load_smb_module()->SMBGetFile))
#define XF_SMBDropFile (*(load_smb_module()->SMBDropFile))
#define XF_SMBrmFile (*(load_smb_module()->SMBrmFile))
#define XF_SMBmkdir (*(load_smb_module()->SMBmkdir))
#define XF_SMBwait (*(load_smb_module()->SMBwait))
#define XF_SMBget_cache_file (*(load_smb_module()->SMBget_cache_file))
#define XF_SMBget_netfile_cache_dir (*(load_smb_module()->SMBget_netfile_cache_dir))

#endif
#endif

