// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#include "threadstatesaver.h"

namespace Shiboken
{

ThreadStateSaver::ThreadStateSaver() = default;

ThreadStateSaver::~ThreadStateSaver()
{
    restore();
}

void ThreadStateSaver::save()
{
    if (Py_IsInitialized())
        m_threadState = PyEval_SaveThread();
}

void ThreadStateSaver::restore()
{
    if (m_threadState) {
        PyEval_RestoreThread(m_threadState);
        m_threadState = nullptr;
    }
}

} // namespace Shiboken

