/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.optimizers;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.sail.rdbms.algebra.BNodeColumn;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.DatatypeColumn;
import org.openrdf.sail.rdbms.algebra.DateTimeColumn;
import org.openrdf.sail.rdbms.algebra.HashColumn;
import org.openrdf.sail.rdbms.algebra.IdColumn;
import org.openrdf.sail.rdbms.algebra.LabelColumn;
import org.openrdf.sail.rdbms.algebra.LanguageColumn;
import org.openrdf.sail.rdbms.algebra.LongLabelColumn;
import org.openrdf.sail.rdbms.algebra.LongURIColumn;
import org.openrdf.sail.rdbms.algebra.NumericColumn;
import org.openrdf.sail.rdbms.algebra.RefIdColumn;
import org.openrdf.sail.rdbms.algebra.SelectQuery;
import org.openrdf.sail.rdbms.algebra.SqlIsNull;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.URIColumn;
import org.openrdf.sail.rdbms.algebra.base.FromItem;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.ValueColumnBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarColumnLookupOptimizer
extends RdbmsQueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    private FromItem parent;
    private FromItem gparent;

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        this.parent = null;
        tupleExpr.visit(this);
    }

    @Override
    public void meetFromItem(FromItem node) throws RuntimeException {
        FromItem top = this.gparent;
        this.gparent = this.parent;
        this.parent = node;
        super.meetFromItem(node);
        this.parent = this.gparent;
        this.gparent = top;
    }

    @Override
    public void meet(SelectQuery node) throws RuntimeException {
        this.gparent = node.getFrom();
        this.parent = node.getFrom();
        super.meet(node);
        this.parent = null;
        this.gparent = null;
    }

    @Override
    public void meet(BNodeColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isBNodes()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(DatatypeColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isTyped()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(DateTimeColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isCalendar()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(LabelColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isLiterals()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(LongLabelColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isLong() || !var.getTypes().isLiterals()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(LanguageColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isLanguages()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(NumericColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isNumeric()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(LongURIColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isLong() || !var.getTypes().isURIs()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(URIColumn node) throws RuntimeException {
        ColumnVar var = this.replaceVar(node);
        if (var == null) {
            return;
        }
        if (!var.getTypes().isURIs()) {
            node.replaceWith(new SqlNull());
        }
    }

    @Override
    public void meet(RefIdColumn node) throws RuntimeException {
        this.replaceVar(node);
    }

    @Override
    public void meet(HashColumn node) throws RuntimeException {
        this.replaceVar(node);
    }

    private ColumnVar replaceVar(ValueColumnBase node) {
        ColumnVar var = this.gparent == this.parent ? this.parent.getVar(node.getVarName()) : this.gparent.getVarForChildren(node.getVarName());
        if (var == null) {
            node.replaceWith(new SqlNull());
        } else if (var.isImplied() && node.getParentNode() instanceof SqlIsNull) {
            node.replaceWith(new IdColumn(var.getAlias(), "subj"));
        } else {
            node.setRdbmsVar(var);
        }
        return var;
    }
}

