/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import java.util.Comparator;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.util.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderComparator
implements Comparator<BindingSet> {
    private Logger logger = LoggerFactory.getLogger(OrderComparator.class);
    private EvaluationStrategy strategy;
    private Order order;
    private ValueComparator cmp;

    public OrderComparator(EvaluationStrategy strategy, Order order, ValueComparator vcmp) {
        this.strategy = strategy;
        this.order = order;
        this.cmp = vcmp;
    }

    @Override
    public int compare(BindingSet o1, BindingSet o2) {
        try {
            for (OrderElem element : this.order.getElements()) {
                Value v2;
                Value v1 = this.strategy.evaluate(element.getExpr(), o1);
                int compare = this.cmp.compare(v1, v2 = this.strategy.evaluate(element.getExpr(), o2));
                if (compare == 0) continue;
                if (element.isAscending()) {
                    return compare;
                }
                if (compare > 0) {
                    return -1;
                }
                if (compare >= 0) continue;
                return 1;
            }
            return 0;
        }
        catch (QueryEvaluationException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return 0;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

