/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public class LiteralUtil {
    public static String getLabel(Literal l, String fallback) {
        return l != null ? l.getLabel() : fallback;
    }

    public static String getLabel(Value v, String fallback) {
        return v instanceof Literal ? LiteralUtil.getLabel((Literal)v, fallback) : fallback;
    }

    public static byte getByteValue(Literal l, byte fallback) {
        try {
            return l.byteValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static byte getByteValue(Value v, byte fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getByteValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static short getShortValue(Literal l, short fallback) {
        try {
            return l.shortValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static short getShortValue(Value v, short fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getShortValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static int getIntValue(Literal l, int fallback) {
        try {
            return l.intValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static int getIntValue(Value v, int fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getIntValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static long getLongValue(Literal l, long fallback) {
        try {
            return l.longValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static long getLongValue(Value v, long fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getLongValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static BigInteger getIntegerValue(Literal l, BigInteger fallback) {
        try {
            return l.integerValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static BigInteger getIntegerValue(Value v, BigInteger fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getIntegerValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static BigDecimal getDecimalValue(Literal l, BigDecimal fallback) {
        try {
            return l.decimalValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static BigDecimal getDecimalValue(Value v, BigDecimal fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getDecimalValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static float getFloatValue(Literal l, float fallback) {
        try {
            return l.floatValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static float getFloatValue(Value v, float fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getFloatValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static double getDoubleValue(Literal l, double fallback) {
        try {
            return l.doubleValue();
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static double getDoubleValue(Value v, double fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getDoubleValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static boolean getBooleanValue(Literal l, boolean fallback) {
        try {
            return l.booleanValue();
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static boolean getBooleanValue(Value v, boolean fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getBooleanValue((Literal)v, fallback);
        }
        return fallback;
    }

    public static XMLGregorianCalendar getCalendarValue(Literal l, XMLGregorianCalendar fallback) {
        try {
            return l.calendarValue();
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static XMLGregorianCalendar getCalendarValue(Value v, XMLGregorianCalendar fallback) {
        if (v instanceof Literal) {
            return LiteralUtil.getCalendarValue((Literal)v, fallback);
        }
        return fallback;
    }
}

