/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    public static void extract(File zip, File destDir) throws IOException {
        assert (destDir.isDirectory());
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            ZipUtil.writeEntry(zipFile, entry, destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEntry(ZipFile zipFile, ZipEntry entry, File destDir) throws IOException {
        File outFile = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            outFile.mkdirs();
        } else {
            outFile.getParentFile().mkdirs();
            InputStream in = null;
            OutputStream out = null;
            try {
                int len;
                in = zipFile.getInputStream(entry);
                out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }
}

