/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.AbstractLock;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.Properties;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritePrefReadWriteLockManager
implements ReadWriteLockManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean writeRequested = false;
    private boolean writerActive = false;
    private int activeReaders = 0;
    private boolean trackLocks;
    private List<WeakReference<Lock>> readLocks;
    private WeakReference<Lock> writeLock;

    public WritePrefReadWriteLockManager() {
        this(false);
    }

    public WritePrefReadWriteLockManager(boolean trackLocks) {
        boolean bl = this.trackLocks = trackLocks || Properties.lockTrackingEnabled();
        if (this.trackLocks) {
            this.readLocks = new LinkedList<WeakReference<Lock>>();
        }
    }

    public synchronized Lock getReadLock() throws InterruptedException {
        while (this.writerActive || this.writeRequested) {
            this.wait();
        }
        ++this.activeReaders;
        AbstractLock lock = new AbstractLock(this.logger, this.trackLocks){

            protected void releaseLock() {
                WritePrefReadWriteLockManager.this.releaseReadLock(this);
            }
        };
        if (this.trackLocks) {
            this.readLocks.add(new WeakReference<1>(lock));
        }
        return lock;
    }

    private synchronized void releaseReadLock(Lock lock) {
        --this.activeReaders;
        if (this.trackLocks) {
            Iterator<WeakReference<Lock>> iter = this.readLocks.iterator();
            while (iter.hasNext()) {
                if (iter.next().get() != lock) continue;
                iter.remove();
                break;
            }
        }
        if (this.activeReaders == 0) {
            this.notifyAll();
        }
    }

    public synchronized Lock getWriteLock() throws InterruptedException {
        while (this.writeRequested) {
            this.wait();
        }
        this.writeRequested = true;
        while (this.writerActive || this.activeReaders > 0) {
            this.wait();
        }
        this.writerActive = true;
        this.writeRequested = false;
        this.notifyAll();
        AbstractLock lock = new AbstractLock(this.logger, this.trackLocks){

            protected void releaseLock() {
                WritePrefReadWriteLockManager.this.releaseWriteLock();
            }
        };
        if (this.trackLocks) {
            this.writeLock = new WeakReference<2>(lock);
        }
        return lock;
    }

    private synchronized void releaseWriteLock() {
        this.writerActive = false;
        if (this.trackLocks) {
            this.writeLock = null;
        }
        this.notifyAll();
    }
}

