/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "touch.h"

#include "entry.h"
#include "misc.h"
#include "monitor.h"
#include "widgets.h"


G_MODULE_EXPORT
void on_touch_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    tree_entry_t *en;
    gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeIter iter;
    char path[_POSIX_PATH_MAX];


    if(!set_load_wait())
	return;
    en = get_selected_entry(&iter);
    if(!en || !IS_PATH(en->type))
    {
	print_status("xfce/error", strerror(EINVAL), NULL);
	return;
    }
    {
	char *argv[4];
	int status;
	pid_t child;
	argv[0] = "touch";
	argv[1] = path;
	strcpy(path, en->path);
	argv[2] = 0;
	child = fork();
	if(child < 0)
	    assert_not_reached();
	if(!child)
	{
	    execvp(argv[0], argv);
	    _exit(1);
	}
	usleep(50000);
	wait(&status);
    }

    {
	struct stat st;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	stat(en->path, &st);
	memcpy(en->st, &st, sizeof(struct stat));
	update_row(treemodel, &iter, NULL, en);
    }
    unset_load_wait();
    return;
}
