# The PEP 484 type hints stub file for the QtWebKit module.
#
# Generated by SIP 6.14.0
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtNetwork

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QWebDatabase(PyQt5.sipsimplewrapper):

    def __init__(self, other: 'QWebDatabase') -> None: ...

    @staticmethod
    def removeAllDatabases() -> None: ...
    @staticmethod
    def removeDatabase(db: 'QWebDatabase') -> None: ...
    def origin(self) -> 'QWebSecurityOrigin': ...
    def fileName(self) -> str: ...
    def size(self) -> int: ...
    def expectedSize(self) -> int: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...


class QWebElement(PyQt5.sipsimplewrapper):

    class StyleResolveStrategy(int):
        InlineStyle = ... # type: QWebElement.StyleResolveStrategy
        CascadedStyle = ... # type: QWebElement.StyleResolveStrategy
        ComputedStyle = ... # type: QWebElement.StyleResolveStrategy

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWebElement') -> None: ...

    @typing.overload
    def render(self, painter: typing.Optional[QtGui.QPainter]) -> None: ...
    @typing.overload
    def render(self, painter: typing.Optional[QtGui.QPainter], clip: QtCore.QRect) -> None: ...
    def setStyleProperty(self, name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def styleProperty(self, name: typing.Optional[str], strategy: 'QWebElement.StyleResolveStrategy') -> str: ...
    def evaluateJavaScript(self, scriptSource: typing.Optional[str]) -> typing.Any: ...
    def removeAllChildren(self) -> None: ...
    def removeFromDocument(self) -> None: ...
    def takeFromDocument(self) -> 'QWebElement': ...
    def clone(self) -> 'QWebElement': ...
    @typing.overload
    def replace(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def replace(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def encloseWith(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def encloseWith(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def encloseContentsWith(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def encloseContentsWith(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def prependOutside(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def prependOutside(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def appendOutside(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def appendOutside(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def prependInside(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def prependInside(self, element: 'QWebElement') -> None: ...
    @typing.overload
    def appendInside(self, markup: typing.Optional[str]) -> None: ...
    @typing.overload
    def appendInside(self, element: 'QWebElement') -> None: ...
    def webFrame(self) -> typing.Optional[QWebFrame]: ...
    def document(self) -> 'QWebElement': ...
    def previousSibling(self) -> 'QWebElement': ...
    def nextSibling(self) -> 'QWebElement': ...
    def lastChild(self) -> 'QWebElement': ...
    def firstChild(self) -> 'QWebElement': ...
    def parent(self) -> 'QWebElement': ...
    def namespaceUri(self) -> str: ...
    def localName(self) -> str: ...
    def prefix(self) -> str: ...
    def tagName(self) -> str: ...
    def geometry(self) -> QtCore.QRect: ...
    def setFocus(self) -> None: ...
    def hasFocus(self) -> bool: ...
    def toggleClass(self, name: typing.Optional[str]) -> None: ...
    def removeClass(self, name: typing.Optional[str]) -> None: ...
    def addClass(self, name: typing.Optional[str]) -> None: ...
    def hasClass(self, name: typing.Optional[str]) -> bool: ...
    def classes(self) -> list[str]: ...
    def attributeNames(self, namespaceUri: typing.Optional[str] = ...) -> list[str]: ...
    def hasAttributes(self) -> bool: ...
    def removeAttributeNS(self, namespaceUri: typing.Optional[str], name: typing.Optional[str]) -> None: ...
    def removeAttribute(self, name: typing.Optional[str]) -> None: ...
    def hasAttributeNS(self, namespaceUri: typing.Optional[str], name: typing.Optional[str]) -> bool: ...
    def hasAttribute(self, name: typing.Optional[str]) -> bool: ...
    def attributeNS(self, namespaceUri: typing.Optional[str], name: typing.Optional[str], defaultValue: typing.Optional[str] = ...) -> str: ...
    def attribute(self, name: typing.Optional[str], defaultValue: typing.Optional[str] = ...) -> str: ...
    def setAttributeNS(self, namespaceUri: typing.Optional[str], name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def setAttribute(self, name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def toInnerXml(self) -> str: ...
    def setInnerXml(self, markup: typing.Optional[str]) -> None: ...
    def toOuterXml(self) -> str: ...
    def setOuterXml(self, markup: typing.Optional[str]) -> None: ...
    def toPlainText(self) -> str: ...
    def setPlainText(self, text: typing.Optional[str]) -> None: ...
    def findFirst(self, selectorQuery: typing.Optional[str]) -> 'QWebElement': ...
    def findAll(self, selectorQuery: typing.Optional[str]) -> 'QWebElementCollection': ...
    def isNull(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class QWebElementCollection(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, contextElement: QWebElement, query: typing.Optional[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWebElementCollection') -> None: ...

    def toList(self) -> list[QWebElement]: ...
    def last(self) -> QWebElement: ...
    def first(self) -> QWebElement: ...
    def __getitem__(self, i: int) -> QWebElement: ...
    def at(self, i: int) -> QWebElement: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def append(self, collection: 'QWebElementCollection') -> None: ...
    def __iadd__(self, other: 'QWebElementCollection') -> 'QWebElementCollection': ...
    def __add__(self, other: 'QWebElementCollection') -> 'QWebElementCollection': ...


class QWebHistoryItem(PyQt5.sipsimplewrapper):

    def __init__(self, other: 'QWebHistoryItem') -> None: ...

    def isValid(self) -> bool: ...
    def setUserData(self, userData: typing.Any) -> None: ...
    def userData(self) -> typing.Any: ...
    def icon(self) -> QtGui.QIcon: ...
    def lastVisited(self) -> QtCore.QDateTime: ...
    def title(self) -> str: ...
    def url(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...


class QWebHistory(PyQt5.sipsimplewrapper):

    def setMaximumItemCount(self, count: int) -> None: ...
    def maximumItemCount(self) -> int: ...
    def currentItemIndex(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def itemAt(self, i: int) -> QWebHistoryItem: ...
    def forwardItem(self) -> QWebHistoryItem: ...
    def currentItem(self) -> QWebHistoryItem: ...
    def backItem(self) -> QWebHistoryItem: ...
    def goToItem(self, item: QWebHistoryItem) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def canGoForward(self) -> bool: ...
    def canGoBack(self) -> bool: ...
    def forwardItems(self, maxItems: int) -> list[QWebHistoryItem]: ...
    def backItems(self, maxItems: int) -> list[QWebHistoryItem]: ...
    def items(self) -> list[QWebHistoryItem]: ...
    def clear(self) -> None: ...


class QWebHistoryInterface(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def addHistoryEntry(self, url: typing.Optional[str]) -> None: ...
    def historyContains(self, url: typing.Optional[str]) -> bool: ...
    @staticmethod
    def defaultInterface() -> typing.Optional['QWebHistoryInterface']: ...
    @staticmethod
    def setDefaultInterface(defaultInterface: typing.Optional['QWebHistoryInterface']) -> None: ...


class QWebPluginFactory(QtCore.QObject):

    class Extension(int): ...

    class MimeType(PyQt5.sipsimplewrapper):

        description = ... # type: typing.Optional[str]
        fileExtensions = ... # type: collections.abc.Iterable[typing.Optional[str]]
        name = ... # type: typing.Optional[str]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPluginFactory.MimeType') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    class Plugin(PyQt5.sipsimplewrapper):

        description = ... # type: typing.Optional[str]
        mimeTypes = ... # type: collections.abc.Iterable['QWebPluginFactory.MimeType']
        name = ... # type: typing.Optional[str]

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPluginFactory.Plugin') -> None: ...

    class ExtensionOption(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPluginFactory.ExtensionOption') -> None: ...

    class ExtensionReturn(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWebPluginFactory.ExtensionReturn') -> None: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def supportsExtension(self, extension: 'QWebPluginFactory.Extension') -> bool: ...
    def extension(self, extension: 'QWebPluginFactory.Extension', option: typing.Optional['QWebPluginFactory.ExtensionOption'] = ..., output: typing.Optional['QWebPluginFactory.ExtensionReturn'] = ...) -> bool: ...
    def create(self, mimeType: typing.Optional[str], url: QtCore.QUrl, argumentNames: collections.abc.Iterable[typing.Optional[str]], argumentValues: collections.abc.Iterable[typing.Optional[str]]) -> typing.Optional[QtCore.QObject]: ...
    def refreshPlugins(self) -> None: ...
    def plugins(self) -> list['QWebPluginFactory.Plugin']: ...


class QWebSecurityOrigin(PyQt5.sipsimplewrapper):

    class SubdomainSetting(int):
        AllowSubdomains = ... # type: QWebSecurityOrigin.SubdomainSetting
        DisallowSubdomains = ... # type: QWebSecurityOrigin.SubdomainSetting

    @typing.overload
    def __init__(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def __init__(self, other: 'QWebSecurityOrigin') -> None: ...

    def removeAccessWhitelistEntry(self, scheme: typing.Optional[str], host: typing.Optional[str], subdomainSetting: 'QWebSecurityOrigin.SubdomainSetting') -> None: ...
    def addAccessWhitelistEntry(self, scheme: typing.Optional[str], host: typing.Optional[str], subdomainSetting: 'QWebSecurityOrigin.SubdomainSetting') -> None: ...
    def setApplicationCacheQuota(self, quota: int) -> None: ...
    @staticmethod
    def localSchemes() -> list[str]: ...
    @staticmethod
    def removeLocalScheme(scheme: typing.Optional[str]) -> None: ...
    @staticmethod
    def addLocalScheme(scheme: typing.Optional[str]) -> None: ...
    def databases(self) -> list[QWebDatabase]: ...
    def setDatabaseQuota(self, quota: int) -> None: ...
    def databaseQuota(self) -> int: ...
    def databaseUsage(self) -> int: ...
    def port(self) -> int: ...
    def host(self) -> str: ...
    def scheme(self) -> str: ...
    @staticmethod
    def allOrigins() -> list['QWebSecurityOrigin']: ...


class QWebSettings(PyQt5.sipsimplewrapper):

    class ThirdPartyCookiePolicy(int):
        AlwaysAllowThirdPartyCookies = ... # type: QWebSettings.ThirdPartyCookiePolicy
        AlwaysBlockThirdPartyCookies = ... # type: QWebSettings.ThirdPartyCookiePolicy
        AllowThirdPartyWithExistingCookies = ... # type: QWebSettings.ThirdPartyCookiePolicy

    class FontSize(int):
        MinimumFontSize = ... # type: QWebSettings.FontSize
        MinimumLogicalFontSize = ... # type: QWebSettings.FontSize
        DefaultFontSize = ... # type: QWebSettings.FontSize
        DefaultFixedFontSize = ... # type: QWebSettings.FontSize

    class WebGraphic(int):
        MissingImageGraphic = ... # type: QWebSettings.WebGraphic
        MissingPluginGraphic = ... # type: QWebSettings.WebGraphic
        DefaultFrameIconGraphic = ... # type: QWebSettings.WebGraphic
        TextAreaSizeGripCornerGraphic = ... # type: QWebSettings.WebGraphic
        InputSpeechButtonGraphic = ... # type: QWebSettings.WebGraphic
        SearchCancelButtonGraphic = ... # type: QWebSettings.WebGraphic
        SearchCancelButtonPressedGraphic = ... # type: QWebSettings.WebGraphic

    class WebAttribute(int):
        AutoLoadImages = ... # type: QWebSettings.WebAttribute
        JavascriptEnabled = ... # type: QWebSettings.WebAttribute
        JavaEnabled = ... # type: QWebSettings.WebAttribute
        PluginsEnabled = ... # type: QWebSettings.WebAttribute
        PrivateBrowsingEnabled = ... # type: QWebSettings.WebAttribute
        JavascriptCanOpenWindows = ... # type: QWebSettings.WebAttribute
        JavascriptCanCloseWindows = ... # type: QWebSettings.WebAttribute
        JavascriptCanAccessClipboard = ... # type: QWebSettings.WebAttribute
        DeveloperExtrasEnabled = ... # type: QWebSettings.WebAttribute
        LinksIncludedInFocusChain = ... # type: QWebSettings.WebAttribute
        ZoomTextOnly = ... # type: QWebSettings.WebAttribute
        PrintElementBackgrounds = ... # type: QWebSettings.WebAttribute
        OfflineStorageDatabaseEnabled = ... # type: QWebSettings.WebAttribute
        OfflineWebApplicationCacheEnabled = ... # type: QWebSettings.WebAttribute
        LocalStorageDatabaseEnabled = ... # type: QWebSettings.WebAttribute
        LocalStorageEnabled = ... # type: QWebSettings.WebAttribute
        LocalContentCanAccessRemoteUrls = ... # type: QWebSettings.WebAttribute
        DnsPrefetchEnabled = ... # type: QWebSettings.WebAttribute
        XSSAuditingEnabled = ... # type: QWebSettings.WebAttribute
        AcceleratedCompositingEnabled = ... # type: QWebSettings.WebAttribute
        SpatialNavigationEnabled = ... # type: QWebSettings.WebAttribute
        LocalContentCanAccessFileUrls = ... # type: QWebSettings.WebAttribute
        TiledBackingStoreEnabled = ... # type: QWebSettings.WebAttribute
        FrameFlatteningEnabled = ... # type: QWebSettings.WebAttribute
        SiteSpecificQuirksEnabled = ... # type: QWebSettings.WebAttribute
        WebGLEnabled = ... # type: QWebSettings.WebAttribute
        HyperlinkAuditingEnabled = ... # type: QWebSettings.WebAttribute
        CSSRegionsEnabled = ... # type: QWebSettings.WebAttribute
        CSSGridLayoutEnabled = ... # type: QWebSettings.WebAttribute
        ScrollAnimatorEnabled = ... # type: QWebSettings.WebAttribute
        CaretBrowsingEnabled = ... # type: QWebSettings.WebAttribute
        NotificationsEnabled = ... # type: QWebSettings.WebAttribute
        WebAudioEnabled = ... # type: QWebSettings.WebAttribute
        Accelerated2dCanvasEnabled = ... # type: QWebSettings.WebAttribute

    class FontFamily(int):
        StandardFont = ... # type: QWebSettings.FontFamily
        FixedFont = ... # type: QWebSettings.FontFamily
        SerifFont = ... # type: QWebSettings.FontFamily
        SansSerifFont = ... # type: QWebSettings.FontFamily
        CursiveFont = ... # type: QWebSettings.FontFamily
        FantasyFont = ... # type: QWebSettings.FontFamily

    def cssMediaType(self) -> str: ...
    def setCSSMediaType(self, a0: typing.Optional[str]) -> None: ...
    def thirdPartyCookiePolicy(self) -> 'QWebSettings.ThirdPartyCookiePolicy': ...
    def setThirdPartyCookiePolicy(self, a0: 'QWebSettings.ThirdPartyCookiePolicy') -> None: ...
    @staticmethod
    def enablePersistentStorage(path: typing.Optional[str] = ...) -> None: ...
    @staticmethod
    def clearMemoryCaches() -> None: ...
    def localStoragePath(self) -> str: ...
    def setLocalStoragePath(self, path: typing.Optional[str]) -> None: ...
    @staticmethod
    def offlineWebApplicationCacheQuota() -> int: ...
    @staticmethod
    def setOfflineWebApplicationCacheQuota(maximumSize: int) -> None: ...
    @staticmethod
    def offlineWebApplicationCachePath() -> str: ...
    @staticmethod
    def setOfflineWebApplicationCachePath(path: typing.Optional[str]) -> None: ...
    def defaultTextEncoding(self) -> str: ...
    def setDefaultTextEncoding(self, encoding: typing.Optional[str]) -> None: ...
    @staticmethod
    def offlineStorageDefaultQuota() -> int: ...
    @staticmethod
    def setOfflineStorageDefaultQuota(maximumSize: int) -> None: ...
    @staticmethod
    def offlineStoragePath() -> str: ...
    @staticmethod
    def setOfflineStoragePath(path: typing.Optional[str]) -> None: ...
    @staticmethod
    def setObjectCacheCapacities(cacheMinDeadCapacity: int, cacheMaxDead: int, totalCapacity: int) -> None: ...
    @staticmethod
    def maximumPagesInCache() -> int: ...
    @staticmethod
    def setMaximumPagesInCache(pages: int) -> None: ...
    @staticmethod
    def webGraphic(type: 'QWebSettings.WebGraphic') -> QtGui.QPixmap: ...
    @staticmethod
    def setWebGraphic(type: 'QWebSettings.WebGraphic', graphic: QtGui.QPixmap) -> None: ...
    @staticmethod
    def iconForUrl(url: QtCore.QUrl) -> QtGui.QIcon: ...
    @staticmethod
    def clearIconDatabase() -> None: ...
    @staticmethod
    def iconDatabasePath() -> str: ...
    @staticmethod
    def setIconDatabasePath(location: typing.Optional[str]) -> None: ...
    def userStyleSheetUrl(self) -> QtCore.QUrl: ...
    def setUserStyleSheetUrl(self, location: QtCore.QUrl) -> None: ...
    def resetAttribute(self, attr: 'QWebSettings.WebAttribute') -> None: ...
    def testAttribute(self, attr: 'QWebSettings.WebAttribute') -> bool: ...
    def setAttribute(self, attr: 'QWebSettings.WebAttribute', on: bool) -> None: ...
    def resetFontSize(self, type: 'QWebSettings.FontSize') -> None: ...
    def fontSize(self, type: 'QWebSettings.FontSize') -> int: ...
    def setFontSize(self, type: 'QWebSettings.FontSize', size: int) -> None: ...
    def resetFontFamily(self, which: 'QWebSettings.FontFamily') -> None: ...
    def fontFamily(self, which: 'QWebSettings.FontFamily') -> str: ...
    def setFontFamily(self, which: 'QWebSettings.FontFamily', family: typing.Optional[str]) -> None: ...
    @staticmethod
    def globalSettings() -> typing.Optional['QWebSettings']: ...


def qWebKitMinorVersion() -> int: ...
def qWebKitMajorVersion() -> int: ...
def qWebKitVersion() -> str: ...
