/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.TransformationChainsDisambiguator;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;

final class TransformationChainSelector {
    private final ConsumerProvidedVariantFinder transformationChainFinder;
    private final ResolutionFailureHandler failureHandler;

    public TransformationChainSelector(ConsumerProvidedVariantFinder transformationChainFinder, ResolutionFailureHandler failureHandler) {
        this.transformationChainFinder = transformationChainFinder;
        this.failureHandler = failureHandler;
    }

    public Optional<TransformedVariant> selectTransformationChain(ResolvedVariantSet producer, ImmutableAttributes targetAttributes, AttributeMatcher attributeMatcher) {
        List<TransformedVariant> candidateChains = this.transformationChainFinder.findCandidateTransformationChains(producer.getCandidates(), targetAttributes);
        if (candidateChains.size() == 1) {
            return Optional.of(candidateChains.get(0));
        }
        if (candidateChains.size() > 1) {
            TransformationChainsDisambiguator transformationChainsDisambiguator = new TransformationChainsDisambiguator(this.failureHandler, producer, targetAttributes, attributeMatcher, candidateChains);
            return transformationChainsDisambiguator.disambiguate();
        }
        return Optional.empty();
    }
}

