﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/transcribestreaming/TranscribeStreamingService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace TranscribeStreamingService {
namespace Model {

/**
 * <p>Contains entities identified as personal health information (PHI) in your
 * transcription output, along with various associated attributes. Examples include
 * category, confidence score, type, stability score, and start and end
 * times.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-streaming-2017-10-26/MedicalEntity">AWS
 * API Reference</a></p>
 */
class MedicalEntity {
 public:
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalEntity() = default;
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalEntity(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSCRIBESTREAMINGSERVICE_API MedicalEntity& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_TRANSCRIBESTREAMINGSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The start time, in seconds, of the utterance that was identified as PHI.</p>
   */
  inline double GetStartTime() const { return m_startTime; }
  inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
  inline void SetStartTime(double value) {
    m_startTimeHasBeenSet = true;
    m_startTime = value;
  }
  inline MedicalEntity& WithStartTime(double value) {
    SetStartTime(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The end time, in seconds, of the utterance that was identified as PHI.</p>
   */
  inline double GetEndTime() const { return m_endTime; }
  inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }
  inline void SetEndTime(double value) {
    m_endTimeHasBeenSet = true;
    m_endTime = value;
  }
  inline MedicalEntity& WithEndTime(double value) {
    SetEndTime(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The category of information identified. The only category is
   * <code>PHI</code>.</p>
   */
  inline const Aws::String& GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  template <typename CategoryT = Aws::String>
  void SetCategory(CategoryT&& value) {
    m_categoryHasBeenSet = true;
    m_category = std::forward<CategoryT>(value);
  }
  template <typename CategoryT = Aws::String>
  MedicalEntity& WithCategory(CategoryT&& value) {
    SetCategory(std::forward<CategoryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The word or words identified as PHI.</p>
   */
  inline const Aws::String& GetContent() const { return m_content; }
  inline bool ContentHasBeenSet() const { return m_contentHasBeenSet; }
  template <typename ContentT = Aws::String>
  void SetContent(ContentT&& value) {
    m_contentHasBeenSet = true;
    m_content = std::forward<ContentT>(value);
  }
  template <typename ContentT = Aws::String>
  MedicalEntity& WithContent(ContentT&& value) {
    SetContent(std::forward<ContentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The confidence score associated with the identified PHI entity in your
   * audio.</p> <p>Confidence scores are values between 0 and 1. A larger value
   * indicates a higher probability that the identified entity correctly matches the
   * entity spoken in your media.</p>
   */
  inline double GetConfidence() const { return m_confidence; }
  inline bool ConfidenceHasBeenSet() const { return m_confidenceHasBeenSet; }
  inline void SetConfidence(double value) {
    m_confidenceHasBeenSet = true;
    m_confidence = value;
  }
  inline MedicalEntity& WithConfidence(double value) {
    SetConfidence(value);
    return *this;
  }
  ///@}
 private:
  double m_startTime{0.0};
  bool m_startTimeHasBeenSet = false;

  double m_endTime{0.0};
  bool m_endTimeHasBeenSet = false;

  Aws::String m_category;
  bool m_categoryHasBeenSet = false;

  Aws::String m_content;
  bool m_contentHasBeenSet = false;

  double m_confidence{0.0};
  bool m_confidenceHasBeenSet = false;
};

}  // namespace Model
}  // namespace TranscribeStreamingService
}  // namespace Aws
