/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.DefaultZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoSupplier;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FallbackHandlingResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackHandlingResourceHasher.class);
    private static final int MAX_FALLBACK_CONTENT_SIZE = 0xA00000;
    private final ResourceHasher delegate;

    public FallbackHandlingResourceHasher(ResourceHasher delegate) {
        this.delegate = delegate;
    }

    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString((CharSequence)this.getClass().getName());
    }

    public @Nullable HashCode hash(RegularFileSnapshotContext snapshotContext) throws IOException {
        return (HashCode)Optional.of(snapshotContext).filter(this::filter).flatMap(path -> this.tryHash(snapshotContext)).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(snapshotContext)));
    }

    public @Nullable HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return Optional.of(zipEntryContext).filter(this::filter).flatMap(FallbackHandlingResourceHasher::withFallbackSafety).map(this::hashSafely).orElse(this.hashWithDelegate(zipEntryContext)).get();
    }

    private Supplier<HashCode> hashSafely(ZipEntryContext safeContext) {
        return IoSupplier.wrap(() -> this.tryHash(safeContext).orElseGet(this.hashWithDelegate(safeContext)));
    }

    private Supplier<HashCode> hashWithDelegate(ZipEntryContext context) {
        return IoSupplier.wrap(() -> this.delegate.hash(context));
    }

    private static Optional<ZipEntryContext> withFallbackSafety(ZipEntryContext zipEntryContext) {
        ZipEntry entry = zipEntryContext.getEntry();
        if (entry.canReopen()) {
            return Optional.of(zipEntryContext);
        }
        if (entry.size() > 0xA00000) {
            LOGGER.debug(zipEntryContext.getFullName() + " is too large (" + entry.size() + ") for safe fallback - skipping.");
            return Optional.empty();
        }
        return Optional.of(new DefaultZipEntryContext(new CachingZipEntry(entry), zipEntryContext.getFullName(), zipEntryContext.getRootParentName()));
    }

    abstract boolean filter(RegularFileSnapshotContext var1);

    abstract boolean filter(ZipEntryContext var1);

    abstract Optional<HashCode> tryHash(RegularFileSnapshotContext var1);

    abstract Optional<HashCode> tryHash(ZipEntryContext var1);

    private static class CachingZipEntry
    implements ZipEntry {
        private final ZipEntry delegate;
        private byte[] content;

        public CachingZipEntry(ZipEntry delegate) {
            this.delegate = delegate;
        }

        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public byte[] getContent() throws IOException {
            if (this.content == null) {
                this.content = this.delegate.getContent();
            }
            return this.content;
        }

        public <T> T withInputStream(ZipEntry.IoFunction<InputStream, T> action) throws IOException {
            return (T)action.apply((Object)new ByteArrayInputStream(this.getContent()));
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean canReopen() {
            return true;
        }

        public ZipEntry.ZipCompressionMethod getCompressionMethod() {
            return this.delegate.getCompressionMethod();
        }
    }
}

