/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.GeneratedFiles;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class GeneratedSingletonFileTree
implements FileSystemMirroringFileTree,
GeneratedFiles {
    private final Factory<File> tmpDirSource;
    private final FileSystem fileSystem;
    private final String fileName;
    private final Action<File> fileGenerationListener;
    private final Action<OutputStream> contentWriter;

    public GeneratedSingletonFileTree(Factory<File> tmpDirSource, String fileName, Action<File> fileGenerationListener, Action<OutputStream> contentWriter, FileSystem fileSystem) {
        this.tmpDirSource = tmpDirSource;
        this.fileName = fileName;
        this.fileGenerationListener = fileGenerationListener;
        this.contentWriter = contentWriter;
        this.fileSystem = fileSystem;
    }

    public Spec toSpec() {
        return new Spec(this.tmpDirSource, this.fileName, this.fileGenerationListener, this.contentWriter);
    }

    private File getTmpDir() {
        return (File)this.tmpDirSource.create();
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    public File getFileWithoutCreating() {
        return this.createFileInstance(this.fileName);
    }

    public File getFile() {
        return new FileVisitDetailsImpl(this.fileName, this.contentWriter, (Chmod)this.fileSystem).getFile();
    }

    private File createFileInstance(String fileName) {
        return new File(this.getTmpDir(), fileName);
    }

    @Override
    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.getFile(), new PatternSet(), this.fileSystem);
    }

    @Override
    public void visitStructure(MinimalFileTree.MinimalFileTreeStructureVisitor visitor, FileTreeInternal owner) {
        visitor.visitFileTree(this.getFile(), new PatternSet(), owner);
    }

    @Override
    public void visit(FileVisitor visitor) {
        FileVisitDetailsImpl fileVisitDetails = new FileVisitDetailsImpl(this.fileName, this.contentWriter, (Chmod)this.fileSystem);
        visitor.visitFile((FileVisitDetails)fileVisitDetails);
    }

    public static class Spec {
        public final Factory<File> tmpDir;
        public final String fileName;
        public final Action<File> fileGenerationListener;
        public final Action<OutputStream> contentGenerator;

        public Spec(Factory<File> tmpDir, String fileName, Action<File> fileGenerationListener, Action<OutputStream> contentGenerator) {
            this.tmpDir = tmpDir;
            this.fileName = fileName;
            this.fileGenerationListener = fileGenerationListener;
            this.contentGenerator = contentGenerator;
        }
    }

    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final String fileName;
        private final Action<OutputStream> generator;
        private long lastModified;
        private long size;
        private File file;

        public FileVisitDetailsImpl(String fileName, Action<OutputStream> generator, Chmod chmod) {
            super(chmod);
            this.fileName = fileName;
            this.generator = generator;
        }

        @Override
        public String getDisplayName() {
            return this.fileName;
        }

        public void stopVisiting() {
        }

        public File getFile() {
            if (this.file == null) {
                this.file = GeneratedSingletonFileTree.this.createFileInstance(this.fileName);
                if (!this.file.exists()) {
                    GeneratedSingletonFileTree.this.fileGenerationListener.execute((Object)this.file);
                    this.copyTo(this.file);
                } else {
                    this.updateFileOnlyWhenGeneratedContentChanges();
                }
                this.lastModified = this.file.lastModified() / 1000L * 1000L;
                this.size = this.file.length();
            }
            return this.file;
        }

        private void updateFileOnlyWhenGeneratedContentChanges() {
            byte[] generatedContent = this.generateContent();
            if (!this.hasContent(generatedContent, this.file)) {
                try {
                    GeneratedSingletonFileTree.this.fileGenerationListener.execute((Object)this.file);
                    Files.write((byte[])generatedContent, (File)this.file);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }

        private byte[] generateContent() {
            StreamByteBuffer buffer = new StreamByteBuffer();
            this.copyTo(buffer.getOutputStream());
            return buffer.readAsByteArray();
        }

        private boolean hasContent(byte[] generatedContent, File file) {
            byte[] existingContent;
            if ((long)generatedContent.length != file.length()) {
                return false;
            }
            try {
                existingContent = Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                return false;
            }
            return Arrays.equals(generatedContent, existingContent);
        }

        @Override
        public void copyTo(OutputStream output) {
            this.generator.execute((Object)output);
        }

        public boolean isDirectory() {
            return false;
        }

        public long getLastModified() {
            this.getFile();
            return this.lastModified;
        }

        public long getSize() {
            this.getFile();
            return this.size;
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return new RelativePath(true, new String[]{this.fileName});
        }
    }
}

