set(TFEL_VERSION 5.1.0)
string(REPLACE "." "_" _TMP_TFEL_VERSION "${TFEL_VERSION}")
string(REPLACE "-" "_"  _NORMALIZED_TFEL_VERSION "${_TMP_TFEL_VERSION}")
set(VERSIONED_TFEL_HOME "TFELHOME_${_NORMALIZED_TFEL_VERSION}")
unset(_TMP_TFEL_VERSION)
unset(_NORMALIZED_TFEL_VERSION)

if(TFEL_DIR)
  set(TFEL_MODULE_PATH ${TFEL_DIR})
else(TFEL_DIR)
  if(TFELHOME)
    set(TFEL_MODULE_PATH ${TFELHOME})
  else(TFELHOME)
    if(DEFINED ENV{${VERSIONED_TFEL_HOME}})
       set(TFEL_MODULE_PATH "$ENV{${VERSIONED_TFEL_HOME}}")
    else(DEFINED ENV{${VERSIONED_TFEL_HOME}})
      if(DEFINED ENV{TFELHOME})
         set(TFEL_MODULE_PATH "$ENV{TFELHOME}")      
      endif(DEFINED ENV{TFELHOME})
    endif(DEFINED ENV{${VERSIONED_TFEL_HOME}})
  endif(TFELHOME)
endif(TFEL_DIR)

set(TFEL_CXX_STANDARD                       "20")
set(TFEL_COMPILER_FLAGS                     "-m64;")
set(TFEL_COMPILER_CXXFLAGS                  ";-DTFEL_HAVE_NORETURN_ATTRIBUTE")
set(TFEL_COMPILER_WARNINGS                  "-Wdisabled-optimization;-Wno-unused-macros;-Wno-missing-declarations;-Wno-sign-compare;-Wno-switch-enum;-Wsuggest-override;-Wint-in-bool-context;-Wregister;-Wduplicated-branches;-Wmisleading-indentation;-Wduplicated-cond;-Wnull-dereference;-Wtautological-compare;-Wshift-overflow;-Wshift-negative-value;-Wbool-compare;-Wsizeof-array-argument;-Wlogical-not-parentheses;-Wswitch-bool;-Wsequence-point;-Wignored-qualifiers;-Wvector-operation-performance;-Wtrampolines;-Wstrict-null-sentinel;-Wold-style-cast;-Wnoexcept;-Wmissing-include-dirs;-Wlogical-op;-Winit-self;-Wdouble-promotion;-Wno-conversion;-Wreorder;-Wundef;-Wunknown-pragmas;-Wredundant-decls;-Wpacked;-Wno-deprecated-declarations;-Wno-multichar;-Wmissing-format-attribute;-Wno-endif-labels;-Wfloat-equal;-Wreturn-type;-Woverloaded-virtual;-Wnon-virtual-dtor;-Wctor-dtor-privacy;-Wwrite-strings;-Wcast-align;-Wcast-qual;-Wpointer-arith;-Wshadow;-W;-Wall;-Wno-conversion;")
set(TFEL_OPTIMISATION_FLAGS0                "")
set(TFEL_OPTIMISATION_FLAGS                 "-fno-fast-math;-DTFEL_NO_RUNTIME_CHECK_BOUNDS;-O2;-DNDEBUG;")
set(TFEL_OPTIMISATION_FLAGS2                "-ffast-math;")
set(TFEL_CMAKE_C_FLAGS                      "-m64;;")
set(TFEL_CMAKE_C_FLAGS_DEBUG                "-g")
set(TFEL_CMAKE_C_FLAGS_RELEASE              "")
set(TFEL_CMAKE_C_FLAGS_COVERAGE             "-O0;-g;-DNDEBUG;-fprofile-arcs;-ftest-coverage")
set(TFEL_CMAKE_C_FLAGS_PROFILING            "-pg")
set(TFEL_CMAKE_CXX_FLAGS                    "-fvisibility-inlines-hidden;-fvisibility=hidden;;-Wdisabled-optimization;-Wno-unused-macros;-Wno-missing-declarations;-Wno-sign-compare;-Wno-switch-enum;-Wsuggest-override;-Wint-in-bool-context;-Wregister;-Wduplicated-branches;-Wmisleading-indentation;-Wduplicated-cond;-Wnull-dereference;-Wtautological-compare;-Wshift-overflow;-Wshift-negative-value;-Wbool-compare;-Wsizeof-array-argument;-Wlogical-not-parentheses;-Wswitch-bool;-Wsequence-point;-Wignored-qualifiers;-Wvector-operation-performance;-Wtrampolines;-Wstrict-null-sentinel;-Wold-style-cast;-Wnoexcept;-Wmissing-include-dirs;-Wlogical-op;-Winit-self;-Wdouble-promotion;-Wno-conversion;-Wreorder;-Wundef;-Wunknown-pragmas;-Wredundant-decls;-Wpacked;-Wno-deprecated-declarations;-Wno-multichar;-Wmissing-format-attribute;-Wno-endif-labels;-Wfloat-equal;-Wreturn-type;-Woverloaded-virtual;-Wnon-virtual-dtor;-Wctor-dtor-privacy;-Wwrite-strings;-Wcast-align;-Wcast-qual;-Wpointer-arith;-Wshadow;-W;-Wall;-Wno-conversion;;-m64;;;-DTFEL_HAVE_NORETURN_ATTRIBUTE")
set(TFEL_CMAKE_CXX_FLAGS_DEBUG              "-g")
set(TFEL_CMAKE_CXX_FLAGS_RELEASE            "-fno-fast-math;-DTFEL_NO_RUNTIME_CHECK_BOUNDS;-O2;-DNDEBUG;;")
set(TFEL_CMAKE_CXX_FLAGS_COVERAGE           "-O0;-g;-DNDEBUG;-fprofile-arcs;-ftest-coverage")
set(TFEL_CMAKE_CXX_FLAGS_PROFILING          "-pg")
set(TFEL_CMAKE_EXE_LINKER_FLAGS_COVERAGE    "-fprofile-arcs;-ftest-coverage;-lgcov")
set(TFEL_CMAKE_MODULE_LINKER_FLAGS_COVERAGE "-fprofile-arcs;-ftest-coverage;-lgcov")
set(TFEL_CMAKE_SHARED_LINKER_FLAGS_COVERAGE "-fprofile-arcs;-ftest-coverage;-lgcov")
