---
title: 0.14.1
description: Changes in Typst 0.14.1
---

# Version 0.14.1 (December 3, 2025) { #v0.14.1 }

## PDF export
- Fixed regression where links to labelled elements would sometimes not work correctly [LaurenzV/krilla#304]
- Fixed bug where PDF text attributes could be written incorrectly [#7478]
- Fixed crash in link handling [#7471]
- Fixed crash for zero-sized pages [#7454]
- Fixed crash when a table [`vline`]($table.vline) or [`hline`]($table.hline) has an out-of-bounds index [#7448]
- Fixed crash in formatting of font-related PDF export errors [#7460]
- Fixed crash when a [`footnote`] or [`place`] element was queried and reinserted into the document [#7216]
- Fixed crash for PNGs with invalid metadata [LaurenzV/krilla#286], [LaurenzV/krilla#287]
- Fixed bug where text in SVGs with `fill-and-stroke` paint order could be exported incorrectly [LaurenzV/krilla#292]
- Fixed bug with layer isolation in SVGs where blending/masking is used [LaurenzV/krilla#295]
- Fixed that table headers could be tagged incorrectly in some scenarios [LaurenzV/krilla#289]
- Fixed issues where generated PDFs could differ between 32-bit and 64-bit systems [LaurenzV/krilla#317], [LaurenzV/krilla#316], [LaurenzV/krilla#312]
- Upgraded JPEG decoder used during PDF export for improved compatibility, fixing a case where a valid JPEG was rejected [LaurenzV/krilla#288]
- A PDF document information dictionary that would be empty is now fully omitted instead [LaurenzV/krilla#280]
- A rare crash in PDF tagging was turned into a compiler error [#7450]

## HTML export
- Fixed export of table [headers]($table.header) and [footers]($table.footer) with gutter [#7332]
- A [`page`] set rule in HTML export is now a warning instead of a hard error, in line with how unsupported elements are generally treated [#7513]

## Math
- Fixed regression where `arrow.l.r` could not be used as an [accent]($math.accent) anymore [#7481]
- Fixed that single-letter strings did not react to spaces around them like multi-letter strings do [#7276]
- Fixed that spacing around [`mat`]($math.mat) and [`vec`]($math.vec) with a fence delimiter was whitespace-dependent [#7309]
- Fixed height calculation for horizontally stretched glyphs [#7327]

## Model
- Fixed regression where Typst would error in heading numbering functions that don't handle the counter state `{(0,)}`. This can occur in the first layout iteration. Such errors are usually automatically caught by Typst, which was not the case here. [#7459]

## Text
- Fixed regression where Typst would synthesize superscripts for some fonts even when [typographic]($super.typographic) glyphs were available [#7462]
- Fixed regression where some oblique fonts would be classified as italic [#7483]

## Scripting
- Fixed crash due to violated invariants in [`array.sorted`] [#7520]
- Fixed crashes due to overflow in [`calc.rem`], [`calc.rem-euclid`], [`calc.div-euclid`], [`calc.quo`], and [`calc.gcd`] [#7419]
- Upgraded WebAssembly runtime, fixing a bug that [plugins]($plugin) could run into [#7438]

## Command Line Interface
- Compiling to standard output in combination with `--deps --deps-format=make` (which results in an error) will not produce an empty Make dependency file as a side effect anymore [#7246]

## Development
- Increased minimum supported Rust version to 1.89 [#7363]

## Contributors
<contributors from="v0.14.0" to="v0.14.1" />
