# SIESTA 5.4.1 Release Notes (2025-09-16)

## Changes and improvements

- Updated the real part of the Ewald summation in QMMM routines to make it more numerically correct.

  ([506](https://gitlab.com/siesta-project/siesta/-/merge_requests/506))


- Added several QoL changes to the QMMM driver:

  * Removed number of electrons check in the MM driver. Not only it was incorrect, but also the driver should not care about that, that's a thing for SIESTA to handle.
  * Driver no longer dies when re-running due to a missprinted lst file. 
  * When using the "LaunchSIESTA" option, now the driver prints "MD.TypeOfRun qmmm" to the siesta input file.
  * Increased character length for pipe names, since they were inconsistent with the default "slabel.siesta.X".
  * Reworked the check-die part for number of constraints, since it also died if total temperature was 0 K.

  ([510](https://gitlab.com/siesta-project/siesta/-/merge_requests/510))



## Bugfixes

- This fixes indexing issues and incorrect signs of derivative matrix elements.

  ([484](https://gitlab.com/siesta-project/siesta/-/merge_requests/484))


- Added workaround for C_PTR inclusion in newer gnu compilers. This fixes FFTW compilation.

  ([489](https://gitlab.com/siesta-project/siesta/-/merge_requests/489))


- Fix TargetStress.Voigt not being available for most minimizers.

  ([490](https://gitlab.com/siesta-project/siesta/-/merge_requests/490))


- Fixed reciprocal part of the QM-MM interaction not being calculated if all
  MM atoms were outside the QM-MM cutoff.

  ([495](https://gitlab.com/siesta-project/siesta/-/merge_requests/495))


- Fixed missing imports in QMMM driver and Lindhard, which made the NVIDIA compiler crash.

  ([496](https://gitlab.com/siesta-project/siesta/-/merge_requests/496))


- Fix NCDF error -57 for "Save.Overlap.Gradient T" using a non-parallel netcdf library

  ([500](https://gitlab.com/siesta-project/siesta/-/merge_requests/500))


- Fixed wrong nullification of array H_tmp in final_H_f_stress, which resulted in a deallocation error in some systems.

  ([505](https://gitlab.com/siesta-project/siesta/-/merge_requests/505))


- Reverted limited writing of Hamiltonian files

  In 5.4.0 merge !327 was introducing a limited
  writing of HSX/TSHS files in MD simulations.
  This meant that one could not store each steps
  Hamiltonian, thereby overwriting the prior
  steps Hamiltonian.
  The prior behavior of always storing the Hamiltonian
  for the latest converged step is now restored.

  ([515](https://gitlab.com/siesta-project/siesta/-/merge_requests/515))


- Fixed FFTW check in STM utilities.

  ([521](https://gitlab.com/siesta-project/siesta/-/merge_requests/521))



## Build related

- (Re)-enabled NetCDF parallel writes

  A flag was erroneously used and thus
  parallel writes were not possibly since 5.0.

  ([486](https://gitlab.com/siesta-project/siesta/-/merge_requests/486))


- Added more information to the build configure

  Also removed unnecessary dependencies for QMMM-driver

  ([488](https://gitlab.com/siesta-project/siesta/-/merge_requests/488))


- Set Cmake policy 0169 to OLD for wannier90

  This removes a warning about deprecation of FetchContent_Populate
  with a single argument when using recent versions of CMake.

  ([493](https://gitlab.com/siesta-project/siesta/-/merge_requests/493))


- Increase minimum CMake version for ELSI subproject

  ([494](https://gitlab.com/siesta-project/siesta/-/merge_requests/494))


- Use CMAKE_{C,CXX}_STANDARD variables in ELSI. Add header file

  A portable way to specify standard levels. Add header file in scotch library.

  ([508](https://gitlab.com/siesta-project/siesta/-/merge_requests/508))


- Added test of reading a NetCDF file

  This only affects the tests of Siesta.

  ([517](https://gitlab.com/siesta-project/siesta/-/merge_requests/517))


- Provide a basic CMake check that BLAS-linked programs run

  This is run before the return-value-convention test, to catch more general errors

  ([519](https://gitlab.com/siesta-project/siesta/-/merge_requests/519))


- Enabled simpler compiler checks for earlier detection. When the compiler does not work, or there are wrong flags, Cmake will now notify the users much sooner (rather than at a LAPACK check).

  Enabled IPO compilation using SIESTA_WITH_IPO. IPO (interprocedural optimization) can give a performance boost of ~10%.

  ([520](https://gitlab.com/siesta-project/siesta/-/merge_requests/520))


- Use an interface MPI library for mpi_macros

  ([523](https://gitlab.com/siesta-project/siesta/-/merge_requests/523))


- Forcefully set certain cache variables depending on options

  These now works when re-configuring.

  ([523](https://gitlab.com/siesta-project/siesta/-/merge_requests/523))


- Fix definitions of NCDF_4 in siesta_forces

  ([523](https://gitlab.com/siesta-project/siesta/-/merge_requests/523))



## Documentation

- Changed small parts of the manual to enable a smoother integration with pandoc
  and the RST documentation.

  ([499](https://gitlab.com/siesta-project/siesta/-/merge_requests/499))


- Clarified TSHS file format deprecation in manual

  ([514](https://gitlab.com/siesta-project/siesta/-/merge_requests/514))
