source commands.tcl

module PP\#auto -title "PWSCF GUI: module PP.x" -script {

    readfilter  ::pwscf::ppReadFilter

    #
    # Namelist: INPUTPP
    #

    page extract -name "Specify property to calculate" {
	namelist inputpp -name "INPUTPP" {

            var title {
                -label "Title (title):"
                -validate string
            }

            var prefix \
		-label    "Prefix of punch file saved by program PW.X (prefix):" \
		-widget   [list entrybutton "Prefix ..." [list ::pwscf::selectFileRoot $this prefix]] \
		-fmt      %S -validate string \
		-validate string

	    var outdir {
		-label    "Temporary directory where PW.X files resides (outdir):"
		-widget   entrydirselectquote
		-fmt      %S -validate string
		-validate string
	    }
	    var filplot {
		-label    "Output file that will contain the calculated quantity (filplot):"
		-fmt      %S -validate string
		-validate string
	    }
	    var plot_num {
		-label    "What to calculate (plot_num):"
		-widget   radiobox
		-textvalue {
		    "charge density"
		    "total potential (= V_bare + V_H + V_xc)"
		    "local ionic potential (= V_bare)"
		    "local density of states at specific energies (LDOS)" 
		    "local density of electronic entropy"
		    "STM images"
		    "spin polarization (= rho(up) - rho(down))"
		    "|psi|^2"
		    "|psi|^2 (noncollinear case)"
		    "electron localization function (ELF)"
		    "charge density minus superposition of atomic densities"
		    "integrated local density of states (ILDOS)"
		    "electrostatic potential (= V_bare + V_H)"
		    "sawtooth electric field potential"
		    "noncolinear magnetization"
		    "all-electron valence charge density (for PAW)"
		    "exchange-correlation magnetic field (for noncollinear)"
		    "reduced density gradient"
		    "product of density and 2nd-eigenvalue of density Hessian matrix"
		    "all-electron charge density (valence+core, for PAW)"
                    "kinetic energy density (for meta-GGA and XDM only)"
                    "DORI: density overlap regions indicator"
		}
		-value { 0 1 2 3 4 5 6 7 7 8 9 10 11 12 13 17 18 19 20 21 22 123 }
		-fmt %d
	    }
	    dimension spin_component {
		-label    "Spin component (spin_component):"
		-widget   optionmenu
		-textvalue {
                    "spin up + spin down"
                    "spin up only"
                    "spin down only"		

		    "charge"
		    "absolute value"
		    "x component of the magnetization"
		    "y component of the magnetization"
		    "z component of the magnetization"
		}
		-value {
                    0 1 2
                    0 0 1 2 3
                }
		-start 1 -end 2 
	    }	
	    
	    separator -label "--- Options for STM images ---"

	    group stm -name "STM" {
		var sample_bias {
		    -label    "For STM: the bias of the sample [in Ryd] in STM images (sample_bias):"
		    -validate fortranreal
		}
	    }
	    
	    separator -label "--- Options for |psi|^2 ---"

	    group psi2 -name "Psi2" {
		dimension kpoint {
		    -label    "For |psi^2|: which k-point (kpoint):"
		    -widget    spinint
		    -validate  posint
		    -fmt       %d
		    -start 1 -end 2 		    
		}	
		dimension kband {
		    -label    "For |psi^2|: which band (kband):"
		    -widget    spinint
		    -validate  posint
		    -fmt       %d
		    -start 1 -end 2 
		}
		var lsign {
		    -label    "For |psi^2| & Gamma: save the sign(psi) (lsign):"
		    -widget    radiobox
		    -textvalue {Yes No}
		    -value     {.true. .false.}
		}
	    }
	    
	    separator -label "--- Options for LDOS & ILDOS ---"

	    group ildos -name "ILDOS" {
		var emin {
		    -label    "For (I)LDOS: miminum energy [in eV] (emin):"
		    -validate  fortranreal
		}	
		var emax {
		    -label    "FOR (I)LDOS: maximum energy [in eV] (emax):"
		    -validate  fortranreal
		}	
	    }

	    group ldos {
		var delta_e {
		    -label "Spacing of energy grid for LDOS (delta_e):"
		    -validate fortranposreal
		}
		var degauss_ldos {
		    -label "Broadening of energy levels for LDOS in eV (degauss_ldos):"
		    -validate fortrannonnegreal
		}
                var use_gauss_ldos {
                    -label "Use gaussian broadening or LDOS (use_gauss_ldos):"
                    -widget    radiobox
                    -textvalue { Yes No }	      
                    -value     { .true. .false. }
                }
	    }
	}
    }

    #
    # Namelist: PLOT
    #

    page chdens -name "Specify Plot " {

	namelist plot -name "PLOT" {
	    
	    var nfile {
		-label    "Number of data files (nfile):"
		-widget   spinint
		-validate posint
		-default  1
	    }
	    
	    dimension filepp {
		-label    "Filenames of data files:"
		-start    1
		-end      1
		-widget   entryfileselectquote
		-validate string
		-fmt      %S
	    }
	    
	    dimension weight {
		-label    "Weighting factors:"
		-start    1
		-end      1
		-widget   entry
		-validate fortranreal
		-default  1.0
	    }
	    
	    separator -label "--- Plot info ---"
	    
	    var fileout -label "Name of output file (fileout):" -validate string
	    
	    var iflag {
		-label     "Dimensionality of plot (iflag):"
		-textvalue {
		    "1D plot, spherical average"
		    "1D plot"
		    "2D plot"
		    "3D plot"
		    "2D polar plot"
		}
		-value  { 0 1 2 3 4 }
		-widget optionmenu
	    }
	    
	    var output_format {
		-label     "Format of the output (output_format):"
		-textvalue {
		    "XCRYSDEN's XSF format - fast (whole unit cell, 3D)"
		    "XCRYSDEN's XSF format - slow (2D or 3D)" 
		    "format suitable for gnuplot (1D)"
		    "format suitable for plotrho (2D)"
		    "Gaussian cube-file format (3D)"
		    "format suitable for gnuplot (2D)"
		}
		-value     { 5 3 0 2 6 7 }
		-widget    optionmenu
	    }
	    var interpolation { 
		-label     "Interpolation (interpolation):"
                -textvalue { Fourier   bspline }
		-value     { 'fourier' 'bspline' }
		-widget    optionmenu
	    }
	    
	    separator -label "--- Spanning vectors & origin ---"
	    
	    dimension e1 {
		-label    "1st spanning vector:"
		-validate fortranreal
		-start    1
		-end      3
		-pack     left
	    }
	    
	    dimension e2 {
		-label    "2nd spanning vector"
		-validate fortranreal
		-start    1
		-end      3
		-pack     left
	    }
	    
	    dimension e3 {
		-label    "3rd spanning vector"
		-validate fortranreal
		-start    1
		-end      3
		-pack     left
	    }
	    
	    dimension x0 {
		-label    "Origin of the plot"
		-validate fortranreal
		-start    1
		-end      3
		-pack     left
	    }
	    
	    
	    separator -label "--- Number of points in each direction ---" 
	    
	    group nxnynz -name nxnynz {
		packwidgets left
		var nx -label "nx:" -validate posint -widget spinint
		var ny -label "ny:" -validate posint -widget spinint
		var nz -label "nz:" -validate posint -widget spinint
	    }
	    
	    separator -label "--- Polar plot ---"
	    var radius -label "Radius of the sphere (radius):" -validate real
	    
	}
    }
    # ----------------------------------------------------------------------
    # take care of specialties
    # ----------------------------------------------------------------------
    source pp-event.tcl

    # ------------------------------------------------------------------------
    # source the HELP file
    # ------------------------------------------------------------------------
    source pp-help.tcl
}
