# Дополнительные типы данных { #extra-data-types }

До сих пор вы использовали простые типы данных, такие как:

* `int`
* `float`
* `str`
* `bool`

Но вы также можете использовать и более сложные типы.

При этом у вас останутся те же возможности, что и до сих пор:

* Отличная поддержка редактора кода.
* Преобразование данных из входящих запросов.
* Преобразование данных для ответа.
* Валидация данных.
* Автоматическая аннотация и документация.

## Другие типы данных { #other-data-types }

Ниже перечислены некоторые из дополнительных типов данных, которые вы можете использовать:

* `UUID`:
    * Стандартный "Универсальный уникальный идентификатор", используемый в качестве идентификатора во многих базах данных и системах.
    * В запросах и ответах будет представлен как `str`.
* `datetime.datetime`:
    * Встроенный в Python `datetime.datetime`.
    * В запросах и ответах будет представлен как `str` в формате ISO 8601, например: `2008-09-15T15:53:00+05:00`.
* `datetime.date`:
    * Встроенный в Python `datetime.date`.
    * В запросах и ответах будет представлен как `str` в формате ISO 8601, например: `2008-09-15`.
* `datetime.time`:
    * Встроенный в Python `datetime.time`.
    * В запросах и ответах будет представлен как `str` в формате ISO 8601, например: `14:23:55.003`.
* `datetime.timedelta`:
    * Встроенный в Python `datetime.timedelta`.
    * В запросах и ответах будет представлен в виде общего количества секунд типа `float`.
    * Pydantic также позволяет представить его как "Кодировку разницы во времени ISO 8601", <a href="https://docs.pydantic.dev/latest/concepts/serialization/#custom-serializers" class="external-link" target="_blank">см. документацию для получения дополнительной информации</a>.
* `frozenset`:
    * В запросах и ответах обрабатывается так же, как и `set`:
        * В запросах будет прочитан список, исключены дубликаты и преобразован в `set`.
        * В ответах `set` будет преобразован в `list`.
        * В сгенерированной схеме будет указано, что значения `set` уникальны (с помощью JSON-схемы `uniqueItems`).
* `bytes`:
    * Встроенный в Python `bytes`.
    * В запросах и ответах будет рассматриваться как `str`.
    * В сгенерированной схеме будет указано, что это `str` в формате `binary`.
* `Decimal`:
    * Встроенный в Python `Decimal`.
    * В запросах и ответах обрабатывается так же, как и `float`.
* Вы можете проверить все допустимые типы данных Pydantic здесь: <a href="https://docs.pydantic.dev/latest/usage/types/types/" class="external-link" target="_blank">Типы данных Pydantic</a>.

## Пример { #example }

Вот пример *операции пути* с параметрами, который демонстрирует некоторые из вышеперечисленных типов.

{* ../../docs_src/extra_data_types/tutorial001_an_py310.py hl[1,3,12:16] *}

Обратите внимание, что параметры внутри функции имеют свой естественный тип данных, и вы, например, можете выполнять обычные манипуляции с датами, такие как:

{* ../../docs_src/extra_data_types/tutorial001_an_py310.py hl[18:19] *}
